#include <mmsystem.h>
#include <math.h>

HWAVEOUT	g_wo;
int			g_patternNo;
int			g_patternRowNo;

//const float TIME_OFFSET			= 0;
//const int BPM					= 140;
//const int TEMPLATE_MELODY_LEN	= 56;
//const float MASTER_VOLUME		= 0.34f;
//const float PI					= 3.1415926535f;
#define TEMPLATE_MELODY_LEN	56
#define TIME_OFFSET	0.f
#define SAMPLE_FREQUENCY		44000
#define SAMPLE_FREQUENCY_01	 (SAMPLE_FREQUENCY/100)
#define BPM					 140
#define ROW_COUNT			16 * TEMPLATE_MELODY_LEN
#define PLAY_TIME				ROW_COUNT * 60 / ( BPM * 4 )
#define ROW_SIZE_SAMPLES	SAMPLE_FREQUENCY * 60 / ( BPM * 4 )
#define MASTER_VOLUME		0.34f
#define ROW_LEN_SEC		60.0f / ( BPM * 4 )
#define PI 3.1415926535f
#define PI_2  6.283f


struct Instrument { 
	char note;
	char noteEnd;
	char noteLen;
	char volume;
	char oscType;
	char noteOffset;
	char attackTime;
	char decayTime;
	char sustainTime;
	char filterCutoff;
	char filterCutoffModulation;
	char filterRes;
	char echoDelay;
	char echoRepeats;
	char echoDamping;
	char wrapLevel;
	char hardLevel;
	char compressorLow;
	char compressorHigh;
	char pan;
	char resFilterFreq;
	char resFilterFreqModulation;
	char resFilterRes;
};

struct Instrument g_instruments[] = { { -3,0,23,6,3,0,4,22,34,-10,0,75,0,0,0,0,0,0,0,0,127,27,83 }
, { -1,5,17,56,0,0,0,19,64,0,0,0,0,0,0,0,0,0,0,0,100,0,37 }
, { -1,0,26,2,3,0,11,52,127,0,0,0,0,0,0,0,0,0,0,0,75,127,71 }
, { -2,29,11,35,0,0,0,20,80,-10,0,0,0,0,0,0,0,0,0,0,0,0,0 }
, { -2,0,15,21,3,0,0,43,80,-10,0,78,0,0,0,0,0,0,0,0,0,0,0 }
, { -2,0,23,14,3,0,0,31,80,-10,0,0,0,0,0,0,0,0,0,0,0,0,0 }
, { 45,0,-4,12,3,0,0,29,29,-10,0,79,0,0,0,0,0,0,0,0,0,0,0 }
, { -5,0,16,-6,1,-12,0,18,43,0,1,0,12,3,34,0,0,0,0,6,0,4,0 }
, { -5,0,30,-6,0,-12,0,16,35,0,0,83,0,0,0,0,0,0,0,-32,0,53,61 }
, { -1,5,29,9,2,5,0,27,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0 }
, { -7,0,11,-6,2,0,0,35,66,13,0,65,0,0,0,0,0,0,0,0,0,0,0 }
, { -8,0,100,10,1,-20,99,99,99,0,0,0,0,0,0,0,0,0,0,0,0,0,0 }
, { -8,0,100,19,0,-20,81,81,81,0,0,0,0,0,0,0,0,0,0,0,0,0,0 }
, { -9,0,20,16,1,0,0,12,12,-10,0,75,14,4,45,0,0,0,0,0,3,0,53 }
, { -9,0,10,21,0,0,0,29,55,-10,0,59,17,2,44,0,0,13,104,0,21,0,75 }
 };
//const int INSTRUMENT_COUNT = sizeof(g_instruments) / sizeof(Instrument);

const char g_bytePatterns[][16] = { {26,0,26,0,0,0,0,0,0,0,26,0,0,0,0,26},
{0,0,0,0,47,0,0,0,0,0,0,0,47,0,0,0},
{0,0,0,0,0,0,0,11,0,11,0,0,0,0,0,0},
{4,0,4,0,4,0,8,0,4,0,4,0,0,0,4,0},
{26,0,0,0,0,0,0,0,26,0,0,0,0,0,0,0},
{26,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40},
{49,0,49,0,49,0,49,33,0,0,33,0,49,0,49,0},
{49,0,49,32,0,0,32,0,49,0,49,0,31,0,43,0},
{50,0,20,0,10,0,10,50,0,0,50,0,50,0,20,0},
{10,0,10,50,0,0,50,0,50,0,20,0,50,0,50,0},
{45,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{45,49,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{48,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{51,46,0,0,0,0,0,0,46,50,0,0,0,0,0,0},
{44,0,0,0,47,0,44,0,0,0,47,0,44,0,47,0},
{43,0,0,0,47,0,43,0,0,0,47,0,43,0,47,0},
{40,0,0,0,47,0,40,0,47,0,0,0,40,0,0,0},
{48,0,40,0,0,0,48,0,40,0,45,0,0,0,0,0},
{3,5,7,10,12,15,17,20,22,25,27,30,32,35,37,40},
{40,43,46,50,53,56,60,63,66,70,73,76,80,83,86,90},
{90,87,84,80,77,74,70,67,64,60,57,54,50,47,44,40},
{40,38,36,33,31,28,26,23,21,18,16,13,11,8,6,3},
{3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4},
{89,89,89,89,89,89,89,89,89,89,89,89,89,89,89,90}};

const char g_byteSequences[][TEMPLATE_MELODY_LEN] = { {0,1,1,1,1,0,0,6,5,5,1,5,0,0,0,0,0,0,0,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,6,1,1,1,1,1,1,1,1,0,0,0,0},
{2,2,2,2,2,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,0,0,0,0},
{3,3,3,3,3,3,0,0,0,0,0,3,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{4,0,0,4,4,0,4,4,4,4,4,4,4,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,7,8,7,9,8,7,8,7,8,7,0,7,8,7,8,0,0,0,0,7,8,7,8,7,8,7,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,8,7,8,7,8,7,8,0,0,0,0},
{0,9,10,9,10,9,10,9,10,9,10,9,10,10,10,9,10,9,10,9,10,9,10,9,10,9,10,9,10,9,10,9,0,0,0,0,10,0,0,0,9,10,9,10,9,10,9,10,9,10,9,10,0,0,0,0},
{0,0,0,0,0,0,8,7,8,7,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,8,7,8,0,0,0,0,15,16,17,18,7,8,7,8,0,0,0,0,0,0,0,0,15,16,17,18},
{0,0,0,0,0,0,0,0,0,0,0,0,11,12,13,14,11,12,13,14,11,12,13,14,11,12,13,14,11,12,13,14,11,12,13,14,0,0,0,0,0,0,0,0,0,0,0,0,11,12,13,14,11,12,13,14},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,15,16,17,18,15,16,17,18,15,16,17,18,15,16,17,18,15,16,17,18,0,0,0,0},
{19,20,24,24,24,24,24,24,24,21,22,24,24,24,24,24,24,24,24,0,0,0,0,0,0,0,0,0,0,0,0,0,23,19,20,24,24,24,21,22,23,23,23,20,0,0,0,0,0,0,0,0,0,0,0,0}};

int INSTRUMENT_COUNT = sizeof(g_instruments) / sizeof(g_instruments[0]);

// Some auxiliary functions
float Sign ( float f ) {
	if ( f > 0.0f )
		return 1.0f;
	return -1.0f;
}
float CutLevel ( float x, float lvl ) {
	if ( x > lvl )
		return lvl;
	if ( x < -lvl )
		return -lvl;
	return x;
}
float buf0LPRes, buf1LPRes;
float LowPassResonantFilter ( float x, float f, float q ) {
	float fb = q + q / ( 1.0f - f );
	buf0LPRes = buf0LPRes + f * ( x - buf0LPRes + fb * ( buf0LPRes - buf1LPRes ) );
	buf1LPRes = buf1LPRes + f * ( buf0LPRes - buf1LPRes );
	return buf1LPRes;
}
float buf1Res, buf2Res;
float my_sin ( float v ) {
	__asm { 
		fld v
		fsin
		fstp v
	}
	return v;
}
float my_cos ( float v ) {
	__asm {
		fld v
		fcos
		fstp v
	}
	return v;
}
float my_sqrt ( float v ) {
	__asm {
		fld v
		fsqrt
		fstp v
	}
	return v;
}
float my_fabs ( float v ) {
	__asm {
		fld v
		fabs
		fstp v
	}
	return v;
}
int _ftol ( float fvar ) {
	int lvar;
	__asm {
		fld fvar
		fistp lvar
	}
	return lvar;
}
float pow2 ( float x ) {
	float y;
	__asm {
		fld dword ptr x
		fld st(0)
		frndint
		fxch st(1)
		fsub st(0),st(1)
		f2xm1
		fld1
		faddp st(1),st(0)
		fscale
		fstp st(1)
		fstp dword ptr y
	}
	return y;
}
float Noise1 ( int x ) {
    x = (x<<13) ^ x;
    return (float)( 1.0f - ( (x * (x * x * 15731 + 789221) + 1376312589) & 0x7fffffff) / 1073741824.0f);    
}
float ResonantFilter ( float x, float f, float q ) {
	float y = x + 2.0f * my_cos ( PI * f * 0.25f ) * buf1Res * q - buf2Res * q * q;
	buf2Res = buf1Res;
	buf1Res = y;
	return buf1Res;
}
float Sawtooth ( float x ) {
	return ( ( x - _ftol ( x / PI_2 ) * PI_2 ) / PI_2 ) * 2.0f;
}
float NoteToFrequency ( char note  ) {
	return PI_2 * 440.0f * pow2 ( (note-45)/12.0f );
}
float Square ( float x ) {
	return Sign ( Sawtooth ( x ) );
}
char GetFixedOrStreamValue ( char val ) {
	if ( val >= 0 )
		return val;
	val = -val;
	int k = g_byteSequences[val-1][g_patternNo];
	if ( k )
		return g_bytePatterns[k-1][g_patternRowNo];
	return 0;
}

WAVEFORMATEX wfx = { WAVE_FORMAT_PCM, 2, SAMPLE_FREQUENCY, SAMPLE_FREQUENCY*4, 4, 16, 0 };
short finalBuf[(PLAY_TIME+20)*SAMPLE_FREQUENCY*2] ; // We need +20 since some sounds (e.g. echoed) can last for a long time. Hope it's large enough :)
float data[(PLAY_TIME+20)*SAMPLE_FREQUENCY*2] ;
WAVEHDR hdr = {0};

// Creates large buffer and fills it with samples. Starts playing generated sound.
// Pefroms no error checking and does not dispose resources.
void CreateAndPlaySynth ( ) {
		waveOutOpen ( &g_wo, WAVE_MAPPER, &wfx,0, 0, CALLBACK_NULL );
	// Loop through all instruments and create sound for each one of them independently
	for ( int i = 0; i < INSTRUMENT_COUNT; i++ ) {
		float *b = data;
		struct Instrument* ins = g_instruments + i; 
		int oscType = ins->oscType;
		float attackTime = ins->attackTime * 0.01f;
		float decayTime = ins->decayTime * 0.01f;
		float sustainTime = ins->sustainTime * 0.01f;
		float tt = ins->pan*0.01f; float pl = 1.0f - tt; float pr = 1.0f + tt;

		// Loop through all rows for given instrument
		for ( int r = 0; r < ROW_COUNT; r++, b += ROW_SIZE_SAMPLES*2 ) {
			g_patternNo = ( r >> 4 );
			g_patternRowNo = ( r & 0xF );
			char note = GetFixedOrStreamValue ( ins->note );
			if ( !note )
				continue;
			note += ins->noteOffset;
			int noteLenSamples = GetFixedOrStreamValue ( ins->noteLen ) * SAMPLE_FREQUENCY_01;
			float f = NoteToFrequency ( note );
			float f1 = f;
			if ( ins->noteEnd )
				f1 = NoteToFrequency ( ins->noteEnd + ins->noteOffset );
			float filtF = GetFixedOrStreamValue ( ins->filterCutoff ) * 0.01f;
			float filtQ = ins->filterRes * 0.01f;
			float filtMod = ins->filterCutoffModulation * 0.01f;
			float resF = ins->resFilterFreq * 0.01f;
			float resQ = ins->resFilterRes * 0.01f;
			float resMod = ins->resFilterFreqModulation * 0.01f;
			buf0LPRes = buf1LPRes = 0; buf1Res = buf2Res = 0;
			float vol = GetFixedOrStreamValue ( ins->volume ) * 0.01f;
			float wrapLevel = ins->wrapLevel * 0.01f;
			float hardLevel = ins->hardLevel * 0.01f;
			float compLow = ins->compressorLow * 0.01f;
			float compHigh = ins->compressorHigh * 0.01f;
			float compDL = compHigh - compLow;
			float *b1 = b;

			// Create one sound sample based on instrument and sequence parameters
			for ( int k = 0; k < noteLenSamples; k++, b1 += 2 ) {
				float t1 = (float) k / noteLenSamples;
				float t = (float) k / SAMPLE_FREQUENCY * ( f + (f1-f)*t1 );
				float y;
				if ( oscType == 0 )
					y = my_sin ( t );
				if ( oscType == 1 )
					y = Sawtooth ( t );
				if ( oscType == 2 )
					y = Square ( t );
				if ( oscType == 3 )
					y = y = Noise1 ( k ) - 0.5f;
				if ( t1 < attackTime )
					y *= t1 / attackTime;
				else if ( t1 < decayTime )
					y *= 1.0f - 0.3f * ( t1 - attackTime ) / ( decayTime - attackTime );
				else if ( t1 < sustainTime )
					y *= 0.7f;
				else
					y *= 0.7f * ( 1.0f - t1  ) / ( 1.0f - sustainTime );
				if ( filtF )
					y = LowPassResonantFilter ( y, filtF + filtMod * t1, filtQ );
				if ( resF )
					y = ResonantFilter ( y, resF + resMod * t1, resQ );
				if ( compHigh ) {
					float v = my_fabs ( y ) - compLow;
					if ( v > 0.0f ) {
						v = compHigh - compDL / ( 1.0f + 10.0f * v / compDL );
						y = v * Sign ( y );
					}
				}
				float ss = y * vol;
				*b1 += ss*pl;
				*(b1+1) += ss*pr;
				if ( ins->echoRepeats ) {
					float c = ins->echoDamping*0.01f;
					for ( int kk = 0; kk < ins->echoRepeats; kk++ ) {
						float *ad = b1+_ftol((kk+1)*ins->echoDelay*(0.01f*SAMPLE_FREQUENCY*2));
						*(ad++) += ss*pl*c;
						*ad += ss*pr*c;
						c *= c;
					}
				}
			}
		}
	}

	// Copy just generated sound to audio buffer and play it
	short *s = finalBuf;
	float *d = data;
	for ( int i = 0; i < 2*PLAY_TIME*SAMPLE_FREQUENCY; i++ )
		*(s++) = _ftol ( 32000.0f * CutLevel ( (*(d++)) * MASTER_VOLUME, 1 ) );
	hdr.lpData = (LPSTR) ( finalBuf + 2*(int)(TIME_OFFSET*SAMPLE_FREQUENCY));
	hdr.dwBufferLength  = (PLAY_TIME-TIME_OFFSET)*SAMPLE_FREQUENCY*sizeof(short)*2;
//	waveOutPrepareHeader ( g_wo, &hdr, sizeof(hdr) );
//	waveOutWrite ( g_wo, &hdr, sizeof(hdr) );
}
