#include "rotris.h"
	
.GLOBAL CR_Work
.GLOBAL CR_SetParams
.GLOBAL CR_Init

@ In: r0 = 16 bit signed sample  Out: r0 = 8 bit signed sample (filtered)
CR_Work:
	stmfd sp!,{r1-r12}
	ldr r2,=CR_filtCoefTab
	ldmia r2,{r4-r12}
	smull r1,r3,r4,r0
	smlal r1,r3,r5,r9
	smlal r1,r3,r6,r10
	smlal r1,r3,r7,r11
	smlal r1,r3,r8,r12
	mov r3,r3,lsl #16
	orr r10,r3,r1,lsr #16
	add r2,r2,#20
	stmia r2,{r0,r9-r11}	
	mov r0,r10,asr #8
	ldmfd sp!,{r1-r12}
	bx lr

@ r8=CR_param_cutoff, r9=CR_resonance_cutoff

CR_SetParams:
	stmfd sp!,{r0-r10,lr}
	
	mov r0,#10432 @ 2^28/samplerate
	umull r7,r0,r8,r0   @ r0=omega

	@sn=fsin(omega);
	@cs=fcos(omega);
	ldr r1,=cosTable
	mov r3,#4096
	sub r3,r3,#1
	and r0,r0,r3
	ldr r5,[r1,r0,lsl #2] @ r5=cs=cos(omega)
	add r0,r0,#3072
	and r0,r0,r3
	ldr r6,[r1,r0,lsl #2] @ r6=sn=sin(omega)

	@alpha=Div(sn<<7,resonance>>8);
	mov r0,r6,asl #7
	mov r1,r9,lsr #8
	swi SWI_NO_DIV<<16            @ r0=alpha

	@b0=(65536-cs)>>1;
	@b1=65536-cs;
	@b2=(65536-cs)>>1;
	@a0=65536+alpha;
	@a1=-(cs<<1);
	@a2=65536-alpha;
		
	rsb r7,r5,#65536      @ b1=r7
	mov r6,r7,asr #1      @ b0=b2=r6
	add r1,r0,#65536      @ a0=r1
	sub r8,r0,#65536      @ -a2=r8
	mov r9,r5,asl #1      @ -a1=r9

	@a0=Div(1<<30,a0)<<2;
	mov r0,#1<<30
	swi SWI_NO_DIV<<16
	mov r0,r0,asl #2      @ a0=r0

	@CR_filtCoefTab[0] = longmul(a0,b0,16);
	@CR_filtCoefTab[1] = longmul(a0,b1,16);
	@CR_filtCoefTab[2] = longmul(a0,b2,16);
	@CR_filtCoefTab[3] = longmul(a0,-a1,16);
	@CR_filtCoefTab[4] = longmul(a0,-a2,16);
	
	smull r3,r2,r0,r6
	mov r6,r2,lsl #16
	orr r6,r6,r3,lsr #16  @ r6=(a0*b0)>>16		
	smull r3,r2,r0,r7
	mov r7,r2,lsl #16
	orr r7,r7,r3,lsr #16  @ r7=(a0*b1)>>16		
	smull r3,r2,r0,r9
	mov r9,r2,lsl #16
	orr r9,r9,r3,lsr #16  @ r9=(a0*-a1)>>16		
	smull r3,r2,r0,r8
	mov r10,r2,lsl #16
	orr r10,r10,r3,lsr #16  @ r10=(a0*-a2)>>16	
	
	ldr r3,=CR_filtCoefTab
	mov r8,r6
	stmia r3,{r6-r10}
	
	ldmfd sp!,{r0-r10,lr}
	bx lr

	.LTORG

	.BSS

CR_filtCoefTab:
	.word 0,0,0,0,0,0,0,0,0

	.END
