#include "main.h"

s32 sqrt(s32 n)
{
	asm volatile
	("
		mov	r0, %1
		swi	0x80000
		str	r0, %0
		"
		: "=m" (n)
		: "r" (n)
		: "r0"
	);
	return n;
}

s32 div(s32 dividend, s32 divisor)
{
	asm volatile
	("
		mov	r0, %1
		mov	r1, %2
		swi	0x60000
		str	r0, %0
		"
		: "=m" (dividend)
		: "r" (dividend), "r" (divisor)
		: "r0", "r1", "r3"
	);
	return dividend;
}

void Irq()
{
	u16 flag;

	flag = REG_IF;
	if(flag & IRQ_HBL)
	{
		PAL_BG[0] = bgColor[REG_VCOUNT];
	}
	REG_IF = flag;
}

