;
startXl equ $00
startX  equ $00
startZl equ $00
startZ  equ $00
             
Start:
 di
 ld   sp,$ffec
 ld   a,$0c
 sub  h
 add  a,$a5
 sub  l
 push af
 call firstAction
 call DoubleSpeed
 call LCDoff
 call ClearHiRAM
 call IniHiRAMcode
 call ClearLowRAM
 pop  af
 ld   sp,objectList
 push af
 ld   a,1
 ld   [RenderingEnd],a  ; Not Zero
 call ClearObjects
 call TransDMAcode
 call showBung
 call LCDoff
 di
 ld   hl,lcdInt
 ld   de,$c6c0
 ld   c,$40
 call CopyHLtoDEinC
 pop  af
 jr   nz,.noEmul
 ld   hl,$c6c0+lcd_emu_End-lcdInt
 ld   a,$e1
 ld   [hli],a
 ld   a,$f1
 ld   [hli],a
 ld   a,$d9
 ld   [hli],a
; 
.noEmul
 ei
 jr   @+5
NEWGAME:
 call LCDoff
 call showCred
 call LCDoff
 call ClearScr1Map
 call ClearScrBank1
 call ClearScr2Map
 call ClearScrBank2
 call initApaScr
;
 call Ini_crossfire
;
 xor  a                 ;  a- index of pal    / 0 first
 ld   b,8               ;  b- how many colors/2  / all 64
 ld   hl,MyPal          ; hl- start of Pals
 call SetBkgPalette
 ld   a,code1
 ld   [$2000],a
 call FastTriCodeIni

 ld   a,maps1    ; page
 call map_ini
;
 call ini_common_gfx
;
 ld   a,1
 ldio [$4f],a
 ld   a,gfx
 ld   [$2000],a

 xor  a
 call init_dir
 ld   a,$80
 ld   [vmode],a

 call newGame
 call LCDon
 call eii

 ld   c,1
LOOP:
 inc  c
 dec  c
 push af
;
 ld   a,code1
 ld   [$2000],a
 call SetBGObjects
 ld   a,[IsCrossFire]
 or   a
 call nz,ShowCrossFire
;
 pop  af
 jp   z,noGET

 ld   hl,fuelTemp
 dec  [hl]
 jr   nz,toplivo
 ld   [hl],fuelDelay
 ld   hl,fuel
 ld   a,[hl]
 or   a
 jr   nz,noEmpty
 ld   hl,gameOver
 inc  [hl]
 jr   @+3
noEmpty
 dec  [hl]
 call showFuel
toplivo:

 ld   hl,visible_arr+7*3+5
 ld   a,[hl]
 cp   mx_mount
 jr   c,.noHill1
 ld   a,montDamage
 call decPower
 jr   .noHill2
.noHill1
 ld   l,7*4+5
 ld   a,[hl]
 cp   mx_mount
 jr   c,.noHill2
 ld   a,montDamage
 call decPower

.noHill2:

 ld   a,[nObjBG]
 or   a
 jr   z,noObj_avail
 ld   hl,objectList
enem_shoot:
 inc  l
 inc  l                 ;
 ld   a,[hli]
 cp   3
 jr   c,.nextObj
 cp   7
 jr   nc,.nextObj
 call getRnd
 ld   b,a
 ld   a,[ver]
 and  b
 ld   a,shootDamage
 call z,decPower
.nextObj: 
 ld   a,[nObjBG]
 cp   l
 jr   nz,enem_shoot

noObj_avail:
 call get_visible_part

 call MakeLazyList
 call MakeObjectList
noGET:
 call get_perspectiva
;
 ld   a,code1
 ld   [$2000],a
 call cls_bufer
 call Draw_Triangles

 ld   a,wbuf
 ld   [$ff70],a
 ld   hl,RenderingEnd
 xor  a
 ld   [hl],a
 cp   [hl]
 jr   z,@-1
;
keyLOOP:
 halt
 call GetKeys
 ld   b,a          ; scan code
 ld   a,[gameOver]
 or   a
 jr   z,noGO
 inc  b
 dec  b
 jp   nz,NEWGAME

noGO
 ld   a,b
 and  %00110000      ; 'a','b' keys mask
 push bc
 call nz,Fire
 pop  bc
;
 ld   a,[IsCrossFire]
 or   a
 call nz,move_cur

 ld   c,0          ; flag
 ld   hl,move_tab
 jp   FastRun

ClearVram1:
 ld   a,1
 db   6
ClearVram0:
 xor  a
 ldio [$4f],a
 funk
 db   %00111011
 dw   $1800
 db   0
 dw   $8000
 db   $54
 ret
;
ClearScrBank2:
 ld   a,1
 db   6
ClearScrBank1:
 xor  a
 ldio [$4f],a
 funk
 db   %00111011         ; bc,d,hl
 dw   $1800             ; len
 db   0
 dw   $8000
 db   $54               ; FillHL
 ret
ClearScr1Map:
 ld   h,$98
 db   1                 ; code of 'ld bc,nn'
ClearScr2Map:
 ld   h,$9c
ClearScrMaps:
 xor  a
 ldio [$4f],a
 ld   l,a
 ld   d,a
 push hl
 funk
 db   %00000011         ; bc
 dw   $400
 db   $54               ; FillHL
 pop  hl
 ld   a,1
 ldio [$4f],a
 funk
 db   %00000011         ; bc
 dw   $400
 db   $54               ; FillHL
 ret
;
map_ini:  ; a=map_page
 ld   [$2000],a
 ld   hl,$4000
 ld   a,map_tex1
 call map_ini1
 ld   a,map_tex2
 call map_ini1
 ld   a,map_obj
 call obj_set_rand
 ld   a,map_hi
map_ini1:
 ldio [$ff70],a 
 ld   de,$d000
 ld   bc,$1000
 jp   CopyHLtoDE

obj_set_rand:
 ldio [$ff70],a 
 ld   de,$d000
 ld   bc,$1000
osr:
 push bc
 ld   a,[hli]
 ld   b,a
 and  $80
 ld   c,a          ; diag
 ld   a,b
 and  $7f
 ld   b,a
 cp   13
 jr   nc,.yes
 ld   a,b
 jr   .no
.yes
 call getRnd
 and  3
 add  a,a
 add  a,a
 add  a,b
.no
 or   c
 ld   [de],a
 inc  de
 pop  bc
 dec  bc
 ld   a,b
 or   c
 jr   nz,osr
 ret
 

;
SetFont:
 call ClearVram0
 ld   b,20
 ld   de,MyFnt
 ld   hl,$8000
SetTwoLett:
 ld   c,7
 push de
 ld   a,[de]
 inc  de
 call SetLet
 dec  c
 jr   nz,@-6
 pop  de
 inc  hl
 inc  hl
 ld   c,7
 ld   a,[de]
 inc  de
 swap a
 call SetLet
 dec  c
 jr   nz,@-8
 inc  hl
 inc  hl
 dec  b
 jr   nz,SetTwoLett
 ret
;
SetLet:
 rla
 jr   nc,slet1
 push af
 waitvblank
 set  7,[hl]
 set  6,[hl]
 pop  af
slet1:
 rla
 jr   nc,slet2
 inc  hl
 push af
 waitvblank
 set  5,[hl]
 set  4,[hl]
 pop  af
 dec  hl
slet2:
 rla
 jr   nc,slet3
 push af
 waitvblank
 set  3,[hl]
 set  2,[hl]
 inc  hl
 waitvblank
 set  3,[hl]
 set  2,[hl]
 pop  af
 dec  hl
slet3:
 inc  hl
 inc  hl
 ret
 
theend: