#ifndef _GAME_PARTNER_H
#define _GAME_PARTNER_H

#ifdef WIN32
#include "win32.h"
#else
#ifdef GP32
#include "gp32.h"
#endif
#endif

#include "bookmgr.h"

typedef struct _board
{
	u8  types[32];	/* types des pieces */
	u8  pieces[32];
	u8  board[64];
	s16 bonus;
	u8  castle;		/* end static data = 131 */
	u8  passantb,
		passantw;
	u8	chkp0,chkp1,chkm;
	u8  check;
	u8	max;		/* nb of ctrl */
	u8  count[32];	/* nb ctrl/piece */
	u8  idx[32];	/* idx in ctrl for each piece */
	u8  ctrl[160];	/* ctrl pos buffer, < 150 in tests */
} *Board;

#define isCheck(b,color) ((b)->check&(color==WHITE?1:2))
#define copy(dst,src) gm_memcpy(dst,src,131/*sizeof(struct _board)*/);

#define WHITE	0
#define BLACK	16
#define DEAD	255

#define NOPASSANT 9

#define NOPM	0
#define MAT		1
#define PAT		2

enum {
	STALEMAT =	0,
	YOUWIN,
	IWIN,
	THREEFOLD,
	MOVES50,
	RESIGN,
	ABORT,
	YTIMEOUT,
	ITIMEOUT
};

#define INV(a) (s8)(BLACK-a)

#define MAX				0x7f7f

typedef struct {
	u8 depth;
	u8 initdepth;
} LEVEL;

#define POS(a,b) (((a)<<3)+b)
#define COL(a) (a&0x07)
#define ROW(a) ((a>>3)&0x07)
#define TYPE(b,a) ((b)->pieces[a]>>T_SHIFT)
#define COLOR(a) (a&BLACK)

#define Q_ROOK		8
#define Q_KNIGHT	9
#define Q_BISHOP	10
#define QUEEN		11
#define KING		12
#define K_BISHOP	13
#define K_KNIGHT	14
#define K_ROOK		15

/* Type of pieces */

#define T_WPAWN		0
#define T_BPAWN		1
#define T_ROOK		2
#define T_BISHOP	3
#define T_QUEEN		4
#define T_KNIGHT	5
#define T_KING		6

/* End Type of pieces */

u8		playChess(u8,u8,u8);
void	abortGame();

#endif
