
// === Metaballs & Julia3D.
//  Copyright (c) 2000. Remage / Fresh!mindworkz.
//  Thanks to Rod / Mandula for help & support.

#define BLOBS 6
#define GRID 32             
#define GRID2 16            // GRID/2
#define GRID3 0.12f       // 1.0f / GRID2;
#define GRIDC 0.01f       //  1.0f / (GRID*3)
#define GRIDS 1024        // GRID*GRID

float *Blobs;
int *Frames;
Vect BlobPos[ BLOBS ];

#include "Polytab.h"

#ifndef g0

  #define i0 1
  #define i1 2
  #define i2 8
  #define i3 4
  #define i4 16
  #define i5 32
  #define i6 128 
  #define i7 64

  char *Polytab;
  int PolyIndex[14] = 
    { i0, i0|i1, i0|i3, i0|i7, i0|i1|i3, i2|i3|i5, i3|i5|i6, i0|i1|i2|i3, i0|i1|i2|i4, i1|i2|i5|i6, i0|i1|i2|i5, i0|i1|i3|i6, i1|i2|i4|i7, i1|i2|i4|i5 };
  char PolyTable[14][32] = {
    { 0, 1, 0, 2, 0, 4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 },
    { 0, 2, 0, 4, 1, 3, 0, 4, 1, 3, 1, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 },
    { 0, 1, 0, 2, 0, 4, 1, 3, 2, 3, 3, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 },
    { 0, 1, 0, 2, 0, 4, 1, 7, 5, 7, 6, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 },
    { 0, 2, 2, 3, 3, 7, 0, 2, 0, 4, 3, 7, 0, 4, 1, 5, 3, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 },
    { 0, 2, 1, 3, 2, 6, 1, 3, 2, 6, 3, 7, 1, 5, 4, 5, 5, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 },
    { 1, 3, 2, 3, 3, 7, 1, 5, 4, 5, 5, 7, 2, 6, 4, 6, 6, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 },
    { 0, 4, 1, 5, 2, 6, 1, 5, 2, 6, 3, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 },
    { 1, 3, 2, 3, 2, 6, 1, 3, 1, 5, 4, 5, 2, 6, 4, 5, 4, 6, 1, 3, 2, 6, 4, 5, -1, -1, -1, -1, -1, -1, -1, -1 },
    { 0, 2, 2, 3, 4, 6, 2, 3, 4, 6, 6, 7, 0, 1, 1, 3, 4, 5, 1, 3, 4, 5, 5, 7, -1, -1, -1, -1, -1, -1, -1, -1 },
    { 0, 4, 2, 3, 2, 6, 0, 4, 2, 3, 5, 7, 1, 3, 2, 3, 5, 7, 0, 4, 4, 5, 5, 7, -1, -1, -1, -1, -1, -1, -1, -1 },
    { 0, 2, 2, 3, 3, 7, 0, 2, 0, 4, 3, 7, 0, 4, 1, 5, 3, 7, 2, 6, 4, 6, 6, 7, -1, -1, -1, -1, -1, -1, -1, -1 },
    { 0, 1, 1, 3, 1, 5, 0, 2, 2, 3, 2, 6, 0, 4, 4, 5, 4, 6, 3, 7, 5, 7, 6, 7, -1, -1, -1, -1, -1, -1, -1, -1 },
    { 0, 2, 2, 3, 4, 6, 1, 5, 2, 3, 4, 6, 1, 5, 4, 5, 4, 6, 1, 5, 2, 3, 4, 6, -1, -1, -1, -1, -1, -1, -1, -1 },
   };
  char PolyCoord[8][3] =
    {{ -1, -1, -1 }, { -1, -1, 1 }, { -1, 1, 1 }, { -1, 1, -1 }, { 1, -1, -1 }, { 1, -1, 1 }, { 1, 1, 1 }, { 1, 1, -1 }};

#endif

float Dist2, BlobIso, BlobMax, BlobMax1, BlobMax2;

#ifndef g0

int I, J, K, I2, Idx, xRot, yRot, zRot, Nx, Ny, Nz;

void Blob_xRotate( void )
  {
    J = PolyIndex[I];
    PolyIndex[I] = 0;
    for ( K = 0; K < 8; K++ )
      {
        Nx = PolyCoord[ K ][0];
        Ny = PolyCoord[ K ][2];
        Nz = -PolyCoord[ K ][1];
        for ( I2 = 0; I2 < 8; I2++ )
          if (( PolyCoord[ I2 ][0] == Nx ) && ( PolyCoord[ I2 ][1] == Ny ) && ( PolyCoord[ I2 ][2] == Nz ))
            PolyIndex[I] |= (( J >> K ) & 1 ) << I2; // I2-K csere?
       }
    J = 0;
    while ( PolyTable[I][J] != -1 )
      {
        Nx = PolyCoord[ PolyTable[I][J] ][0];
        Ny = PolyCoord[ PolyTable[I][J] ][2];
        Nz = -PolyCoord[ PolyTable[I][J] ][1];
        for ( I2 = 0; I2 < 8; I2++ )
          if (( PolyCoord[ I2 ][0] == Nx ) && ( PolyCoord[ I2 ][1] == Ny ) && ( PolyCoord[ I2 ][2] == Nz ))
            PolyTable[I][J] = I2;
        J++;
       }
   }

void Blob_yRotate( void )
  {
            J = PolyIndex[I];
            PolyIndex[I] = 0;
            for ( K = 0; K < 8; K++ )
              {
                Nx = PolyCoord[ K ][2];
                Ny = PolyCoord[ K ][1];
                Nz = -PolyCoord[ K ][0];
                for ( I2 = 0; I2 < 8; I2++ )
                  if (( PolyCoord[ I2 ][0] == Nx ) && ( PolyCoord[ I2 ][1] == Ny ) && ( PolyCoord[ I2 ][2] == Nz ))
                    PolyIndex[I2] |= 1 << K;
               }
            J = 0;
            while ( PolyTable[I][J] != -1 )
              {
                Nx = PolyCoord[ PolyTable[I][J] ][2];
                Ny = PolyCoord[ PolyTable[I][J] ][1];
                Nz = -PolyCoord[ PolyTable[I][J] ][0];
                for ( I2 = 0; I2 < 8; I2++ )
                  if (( PolyCoord[ I2 ][0] == Nx ) && ( PolyCoord[ I2 ][1] == Ny ) && ( PolyCoord[ I2 ][2] == Nz ))
                    PolyTable[I][J] = I2;
                J++;
               }
   }

#endif

void Blob_Init( void )
  {
    int I;

    Blobs = (float*) malloc( GRID*GRID*GRID*sizeof( float ));
    Frames = (int*) malloc( GRID*GRID*GRID*sizeof( int ));
    for ( I = 0; I < GRID*GRID*GRID; I++ )
      Frames[I] = -1;

#ifndef g0

    Polytab = (char*) malloc( 256*32 );
    for ( I = 0; I < 256*32; I++ )
      Polytab[I] = -1;
    // --- Generate Marching Cubes Polygonization Table.
    for ( I = 0; I < 14; I++ )
      {
//        for ( yRot = 0; yRot < 4; yRot++ )
          {
//          for ( xRot = 0; xRot < 2; xRot++ )
              {
                // CopyCube.
                J = 0;
                Idx = PolyIndex[I];
                while ( PolyTable[I][J] != -1 )
                  {
                    Polytab[ 32*Idx + J ] = PolyTable[I][J];
                    J++;
                   }
                // Rotate(x).
                Blob_xRotate();
               }
//          Blob_yRotate();
           }
       }    

/*
<Bred_rg42> 
sv = (FLOAT)sinf( angle.x);
cv = (FLOAT)cosf( angle.x);
anglexm._22 = anglexm._33 = cv;
anglexm._23 = sv;
cv = (FLOAT)cosf( angle.z);
anglezm._11 = anglezm._22 = cv;
anglezm._12 = sv;
anglezm._21 = -sv;
*/

#endif

   }

int Ofs, DX1, DX2, DY1, DY2, DZ1, DZ2, Pt, Cube;
float X0, Y0, Z0, DB, Neg;

void March_Cube( int X, int Y, int Z )
  {
    Ofs = X*GRIDS +Y*GRID + Z;
    if ( Frames[ Ofs ] != Frame )
      {
        Frames[ Ofs ] = Frame;

        Pt = 0;
        Neg = 1.0f;
        Cube = 
          (( Blobs[ Ofs ] > BlobIso ) ? 1:0 ) +
          (( Blobs[ Ofs+1 ] > BlobIso ) ? 2:0 ) +
          (( Blobs[ Ofs+GRID+1 ] > BlobIso ) ? 4:0 ) +
          (( Blobs[ Ofs+GRID ] > BlobIso ) ? 8:0 ) +
          (( Blobs[ Ofs+GRIDS ] > BlobIso ) ? 16:0 ) +
          (( Blobs[ Ofs+GRIDS+1 ] > BlobIso ) ? 32:0 ) +
          (( Blobs[ Ofs+GRIDS+GRID+1 ] > BlobIso ) ? 64:0 ) +
          (( Blobs[ Ofs+GRIDS+GRID ] > BlobIso ) ? 128:0 );

        if ( !Cube )
          {
            Cube = 
              (( Blobs[ Ofs ] < -BlobIso ) ? 1:0 ) +
              (( Blobs[ Ofs+1 ] < -BlobIso ) ? 2:0 ) +
              (( Blobs[ Ofs+GRID+1 ] < -BlobIso ) ? 4:0 ) +
              (( Blobs[ Ofs+GRID ] < -BlobIso ) ? 8:0 ) +
              (( Blobs[ Ofs+GRIDS ] < -BlobIso ) ? 16:0 ) +
              (( Blobs[ Ofs+GRIDS+1 ] < -BlobIso ) ? 32:0 ) +
              (( Blobs[ Ofs+GRIDS+GRID+1 ] < -BlobIso ) ? 64:0 ) +
              (( Blobs[ Ofs+GRIDS+GRID ] < -BlobIso ) ? 128:0 );
            Neg = -1.0f;
           }

        if ( Cube )
          {
            Cube <<= 5;

            while ( Polytab[ Cube + Pt ] > -1 )
              {
                glColor3f( (float) (X+Y+Z) * GRIDC, (float) (X+Y+Z) /* ( 0.9f + Neg*0.1f ) */* GRIDC, (float) (X+Y+Z) * GRIDC );

                for ( int w = 0; w < 3; w++ )
                  {
                    DX1 = X + (( Polytab[ Cube + Pt+0 ] & 4 ) >> 2);
                    DX2 = X + (( Polytab[ Cube + Pt+1 ] & 4 ) >> 2);
                    DY1 = Y + (( Polytab[ Cube + Pt+0 ] & 2 ) >> 1);
                    DY2 = Y + (( Polytab[ Cube + Pt+1 ] & 2 ) >> 1);
                    DZ1 = Z + (( Polytab[ Cube + Pt+0 ] & 1 ));
                    DZ2 = Z + (( Polytab[ Cube + Pt+1 ] & 1 ));

                    DB = 1.0f / ( Blobs[ DX2*GRIDS + DY2*GRID + DZ2 ] - Blobs[ DX1*GRIDS + DY1*GRID + DZ1 ] );

                    X0 = DX1 + ( DX2 - DX1 ) * ( Neg * BlobIso - Blobs[ DX1*GRIDS + DY1*GRID + DZ1 ] ) * DB;
                    Y0 = DY1 + ( DY2 - DY1 ) * ( Neg * BlobIso - Blobs[ DX1*GRIDS + DY1*GRID + DZ1 ] ) * DB;
                    Z0 = DZ1 + ( DZ2 - DZ1 ) * ( Neg * BlobIso - Blobs[ DX1*GRIDS + DY1*GRID + DZ1 ] ) * DB;
                
                    glVertex3f( X0 - GRID2, Y0 - GRID2, Z0 - GRID2  );
                    Pt += 2;
                   }
               }  
/*
            // Recursive Calls.
            if ( X>1 ) 
              if ( Frames[ (X-1)*GRIDS + Y*GRID + Z ] != Frame )
                March_Cube( X-1, Y, Z );
            if ( X<GRID-3 ) 
              if ( Frames[ (X+1)*GRIDS + Y*GRID + Z ] != Frame )
                March_Cube( X+1, Y, Z );
            if ( Y>1 ) 
              if ( Frames[ X*GRIDS + (Y-1)*GRID + Z ] != Frame )
                March_Cube( X, Y-1, Z );
            if ( Y<GRID-3 ) 
              if ( Frames[ X*GRIDS + (Y+1)*GRID + Z ] != Frame )
                March_Cube( X, Y+1, Z );
            if ( Z>1 ) 
              if ( Frames[ X*GRIDS + Y*GRID + Z-1 ] != Frame )
                March_Cube( X, Y, Z-1 );
            if ( Z<GRID-3 ) 
              if ( Frames[ X*GRIDS + Y*GRID + Z+1 ] != Frame )
                March_Cube( X, Y, Z+1 );
*/
           }
       }
   }

void MarchingCubes( char Negative )
  {
    int X, Y, Z;
//    int Di1, Di2, Dj1, Dj2, Dk1, Dk2, i, j ,k, Pt, Cube;
//    float X0, Y0, Z0, DB;

    glDisable( GL_BLEND );

    glMatrixMode( GL_PROJECTION );
    glLoadIdentity();
    gluPerspective( 90.0f, 640.0f / 480.0f, 1.0f, 100.0f ); 
    gluLookAt( GRID2, GRID2-1, GRID2-2, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f );

    glMatrixMode( GL_MODELVIEW );
    glLoadIdentity();

    glBegin( GL_TRIANGLES );

    BlobIso = 0.18f;
/*
    for ( I = 0; I<BLOBS; I++ )
      March_Cube( Round( BlobPos[I].X ), Round( BlobPos[I].Y ), Round( BlobPos[I].Z ));
*/

    for ( X = 0; X < GRID-1; X++ )
      for ( Y = 0; Y < GRID-1; Y++ )
        for ( Z = 0; Z < GRID-1; Z++ )
          {
            Ofs = X*GRIDS +Y*GRID + Z;
            if ( Frames[ Ofs ] != Frame )
              {
                Frames[ Ofs ] = Frame;

                Pt = 0;
                Neg = 1.0f;
                Cube = 
                  (( Blobs[ Ofs ] > BlobIso ) ? 1:0 ) +
                  (( Blobs[ Ofs+1 ] > BlobIso ) ? 2:0 ) +
                  (( Blobs[ Ofs+GRID+1 ] > BlobIso ) ? 4:0 ) +
                  (( Blobs[ Ofs+GRID ] > BlobIso ) ? 8:0 ) +
                  (( Blobs[ Ofs+GRIDS ] > BlobIso ) ? 16:0 ) +
                  (( Blobs[ Ofs+GRIDS+1 ] > BlobIso ) ? 32:0 ) +
                  (( Blobs[ Ofs+GRIDS+GRID+1 ] > BlobIso ) ? 64:0 ) +
                  (( Blobs[ Ofs+GRIDS+GRID ] > BlobIso ) ? 128:0 );
/*
                if ( !Cube )
                  {
                    Cube = 
                      (( Blobs[ Ofs ] < -BlobIso ) ? 1:0 ) +
                      (( Blobs[ Ofs+1 ] < -BlobIso ) ? 2:0 ) +
                      (( Blobs[ Ofs+GRID+1 ] < -BlobIso ) ? 4:0 ) +
                      (( Blobs[ Ofs+GRID ] < -BlobIso ) ? 8:0 ) +
                      (( Blobs[ Ofs+GRIDS ] < -BlobIso ) ? 16:0 ) +
                      (( Blobs[ Ofs+GRIDS+1 ] < -BlobIso ) ? 32:0 ) +
                      (( Blobs[ Ofs+GRIDS+GRID+1 ] < -BlobIso ) ? 64:0 ) +
                      (( Blobs[ Ofs+GRIDS+GRID ] < -BlobIso ) ? 128:0 );
                    Neg = -1.0f;
                   }
*/
                if ( Cube )
                  {
                    Cube <<= 5;

                    while ( Polytab[ Cube + Pt ] > -1 )
                      {
                        glColor3f( (float) (X+Y+Z) * GRIDC, (float) (X+Y+Z) * ( 0.9f + Neg*0.1f ) * GRIDC, (float) (X+Y+Z) * GRIDC );

                        for ( int w = 0; w < 3; w++ )
                          {
                            DX1 = X + (( Polytab[ Cube + Pt+0 ] & 4 ) >> 2);
                            DX2 = X + (( Polytab[ Cube + Pt+1 ] & 4 ) >> 2);
                            DY1 = Y + (( Polytab[ Cube + Pt+0 ] & 2 ) >> 1);
                            DY2 = Y + (( Polytab[ Cube + Pt+1 ] & 2 ) >> 1);
                            DZ1 = Z + (( Polytab[ Cube + Pt+0 ] & 1 ));
                            DZ2 = Z + (( Polytab[ Cube + Pt+1 ] & 1 ));

                            DB = 1.0f / ( Blobs[ DX2*GRIDS + DY2*GRID + DZ2 ] - Blobs[ DX1*GRIDS + DY1*GRID + DZ1 ] );

                            X0 = DX1 + ( DX2 - DX1 ) * ( Neg * BlobIso - Blobs[ DX1*GRIDS + DY1*GRID + DZ1 ] ) * DB;
                            Y0 = DY1 + ( DY2 - DY1 ) * ( Neg * BlobIso - Blobs[ DX1*GRIDS + DY1*GRID + DZ1 ] ) * DB;
                            Z0 = DZ1 + ( DZ2 - DZ1 ) * ( Neg * BlobIso - Blobs[ DX1*GRIDS + DY1*GRID + DZ1 ] ) * DB;
                
                            glVertex3f( X0 - GRID2, Y0 - GRID2, Z0 - GRID2  );
                            Pt += 2;
                           }
                       }  
                   }
               }
           }
//          March_Cube( I, J, K );

/*
          {
            Pt = 0;
            Cube = 
              (( Blobs[ i*GRIDS + j*GRID + k ] > BlobIso ) ? 1:0 ) +
              (( Blobs[ i*GRIDS + j*GRID + k+1 ] > BlobIso ) ? 2:0 ) +
              (( Blobs[ i*GRIDS + (j+1)*GRID + k+1 ] > BlobIso ) ? 4:0 ) +
              (( Blobs[ i*GRIDS + (j+1)*GRID + k ] > BlobIso ) ? 8:0 ) +
              (( Blobs[ (i+1)*GRIDS + j*GRID + k ] > BlobIso ) ? 16:0 ) +
              (( Blobs[ (i+1)*GRIDS + j*GRID + k+1 ] > BlobIso ) ? 32:0 ) +
              (( Blobs[ (i+1)*GRIDS + (j+1)*GRID + k ] > BlobIso ) ? 128:0 ) +
              (( Blobs[ (i+1)*GRIDS + (j+1)*GRID + k+1 ] > BlobIso ) ? 64:0 );
  
            Cube <<= 5;

            while ( Polytab[ Cube + Pt ] > -1 )
              {
                glColor3f( (float) (i+j+k) * GRIDC, (float) (i+j+k) * GRIDC, (float) (i+j+k) * GRIDC );

                for ( int w = 0; w < 3; w++ )
                  {
                    Di1 = ( Polytab[ Cube + Pt+0 ] & 4 ) >> 2;
                    Di2 = ( Polytab[ Cube + Pt+1 ] & 4 ) >> 2;
                    Dj1 = ( Polytab[ Cube + Pt+0 ] & 2 ) >> 1;
                    Dj2 = ( Polytab[ Cube + Pt+1 ] & 2 ) >> 1;
                    Dk1 = ( Polytab[ Cube + Pt+0 ] & 1 );
                    Dk2 = ( Polytab[ Cube + Pt+1 ] & 1 );

                    DB = 1.0f / ( Blobs[ (i+Di2)*GRIDS + (j+Dj2)*GRID + (k+Dk2) ] - Blobs[ (i+Di1)*GRIDS + (j+Dj1)*GRID + (k+Dk1) ] );

                    X0 = ( i + Di1 ) + ( Di2 - Di1 ) * ( BlobIso - Blobs[ (i+Di1)*GRIDS + (j+Dj1)*GRID + (k+Dk1) ] ) * DB;
                    Y0 = ( j + Dj1 ) + ( Dj2 - Dj1 ) * ( BlobIso - Blobs[ (i+Di1)*GRIDS + (j+Dj1)*GRID + (k+Dk1) ] ) * DB;
                    Z0 = ( k + Dk1 ) + ( Dk2 - Dk1 ) * ( BlobIso - Blobs[ (i+Di1)*GRIDS + (j+Dj1)*GRID + (k+Dk1) ] ) * DB; 
                
                    glVertex3f( X0 - GRID2, Y0 - GRID2, Z0 - GRID2  );
                    Pt += 2;
                   }
               }  

            if ( Negative )
              {
                // Negativ.
                Pt = 0;
                Cube = 
                  (( Blobs[ i*GRIDS + j*GRID + k ] < -BlobIso ) ? 1:0 ) +
                  (( Blobs[ i*GRIDS + j*GRID + k+1 ] < -BlobIso ) ? 2:0 ) +
                  (( Blobs[ i*GRIDS + (j+1)*GRID + k+1 ] < -BlobIso ) ? 4:0 ) +
                  (( Blobs[ i*GRIDS + (j+1)*GRID + k ] < -BlobIso ) ? 8:0 ) +
                  (( Blobs[ (i+1)*GRIDS + j*GRID + k ] < -BlobIso ) ? 16:0 ) +
                  (( Blobs[ (i+1)*GRIDS + j*GRID + k+1 ] < -BlobIso ) ? 32:0 ) +
                  (( Blobs[ (i+1)*GRIDS + (j+1)*GRID + k ] < -BlobIso ) ? 128:0 ) +
                  (( Blobs[ (i+1)*GRIDS + (j+1)*GRID + k+1 ] < -BlobIso ) ? 64:0 );

                Cube <<= 5;

                while ( Polytab[ Cube + Pt ] > -1 )
                  {
                    glColor3f( (i+j+k) * GRIDC, 0.8f * (i+j+k) * GRIDC, (i+j+k) * GRIDC );

                    for ( int w = 0; w < 3; w++ )
                      {
                        Di1 = ( Polytab[ Cube + Pt+0 ] & 4 ) >> 2;
                        Di2 = ( Polytab[ Cube + Pt+1 ] & 4 ) >> 2;
                        Dj1 = ( Polytab[ Cube + Pt+0 ] & 2 ) >> 1;
                        Dj2 = ( Polytab[ Cube + Pt+1 ] & 2 ) >> 1;
                        Dk1 = ( Polytab[ Cube + Pt+0 ] & 1 );
                        Dk2 = ( Polytab[ Cube + Pt+1 ] & 1 );

                        DB = 1.0f / ( Blobs[ (i+Di2)*GRIDS + (j+Dj2)*GRID + (k+Dk2) ] - Blobs[ (i+Di1)*GRIDS + (j+Dj1)*GRID + (k+Dk1) ] );

                        X0 = ( i + Di1 ) + ( Di2 - Di1 ) * ( -BlobIso - Blobs[ (i+Di1)*GRID*GRID + (j+Dj1)*GRID + (k+Dk1) ] ) * DB; 
                        Y0 = ( j + Dj1 ) + ( Dj2 - Dj1 ) * ( -BlobIso - Blobs[ (i+Di1)*GRID*GRID + (j+Dj1)*GRID + (k+Dk1) ] ) * DB; 
                        Z0 = ( k + Dk1 ) + ( Dk2 - Dk1 ) * ( -BlobIso - Blobs[ (i+Di1)*GRID*GRID + (j+Dj1)*GRID + (k+Dk1) ] ) * DB;
                
                        glVertex3f( X0 - GRID2, Y0 - GRID2, Z0 - GRID2  );
                        Pt += 2;
                       }
                   }  
               }
           }
*/
    glEnd();

   }

void Blob_Draw( float Timer )
  {
    int i, j ,k;

    BlobMax = 10.0f;
    BlobMax1 = BlobMax*BlobMax;
    BlobMax2 = 1.0f / BlobMax1;

    for ( i = 0; i < 32; i++ )
      for ( j = 0; j < 32; j++ )
        for ( k = 0; k < 32; k++ )
          Blobs[ i*32*32 + j*32 + k ] = 0.0f;

    for ( int B = 0; B < BLOBS; B++ )
      {
        BlobPos[ B ].X = GRID2 + ( 5.0f + 2.0f * Fsin( Timer * ( 5+B ) * 0.000096f )) * Fcos(( B/8.0f ) + Timer * ( 4+B ) * 0.0005f );
        BlobPos[ B ].Y = GRID2 + ( 5.0f + 2.0f * Fsin( Timer * ( 5+B ) * 0.000093f )) * Fsin(( B/8.0f ) + Timer * ( 4+B ) * 0.0005f );
        BlobPos[ B ].Z = GRID2 + 7.0f * Fcos(( B/8.0f ) + Timer * ( 4+B ) * 0.00045f );

        for ( i = 0; i < GRID; i++ )
          for ( j = 0; j < GRID; j++ )
            for ( k = 0; k < GRID; k++ )
              {
                Dist2 = ( i-BlobPos[ B ].X )*( i-BlobPos[ B ].X ) + ( j-BlobPos[ B ].Y )*( j-BlobPos[ B ].Y ) + ( k-BlobPos[ B ].Z )*( k-BlobPos[ B ].Z );
                if ( Dist2 < BlobMax1 )
                if ( B&1 ) 
                  Blobs[ i*GRIDS + j*GRID + k ] -= ( 1.0f - Dist2 * BlobMax2 ) * ( 1.0f - Dist2 * BlobMax2 ); else  // Negativ blob!
                  Blobs[ i*GRIDS + j*GRID + k ] += ( 1.0f - Dist2 * BlobMax2 ) * ( 1.0f - Dist2 * BlobMax2 ); 
               }
       }
    MarchingCubes( 1 );
   }

// === 3D Julia Morph.

#define JULIA_ITERATION 4

// float Julia_CR = -0.55f, Julia_CI = 0.4f, Julia_CJ = 0.58f, Julia_CK = 0.0f;
float Julia_CR = -0.65f, Julia_CI = 0.4f, Julia_CJ = 0.58f, Julia_CK = 0.2f;

float Julia_Pixel( float x, float y, float z, float w )
  {
    float lprev, length, temp;
   	int m;
    m = 0;
    length = 0;
    do
      {
        temp = x+x;
        x = x*x - y*y - z*z - w*w + Julia_CR;
        y = temp*y + Julia_CI;
        z = temp*z + Julia_CJ;
        w = temp*w + Julia_CK;
        m++;
        lprev = length;
        length = x*x + y*y + z*z + w*w;
       } while (( m < JULIA_ITERATION ) && ( length < 255555.0f ));
    // return ( m - 1 - ( lprev - 255.0f ) / ( length - lprev )) / JULIA_ITERATION;
    // return 1.0f - m / JULIA_ITERATION;
    if ( length > 255.0f ) length = 255.0f;
    return length / 256.0f;
   }

void Julia_Draw( float Timer )
  {
    int i, j, k;

    Julia_CI = 1.2f * Fsin( Timer * 0.0032f / 2 );
    Julia_CJ = 1.2f * Fsin( Timer * 0.0051f / 2 );
    Julia_CK = 1.2f * Fsin( Timer * 0.0037f / 2 );
    Julia_CR = 1.2f * Fsin( Timer * 0.0024f / 2 );

    for ( i = 0; i < GRID; i++ )
      for ( j = 0; j < GRID; j++ )
        for ( k = 0; k < GRID; k++ )
          Blobs[ i*GRID*GRID + j*GRID + k ] =
            Julia_Pixel( GRID3 * ( i - GRID2 ), GRID3 * ( j - GRID2 ), GRID3 * ( k - GRID2 ), 0.0f );

    BlobIso = 0.5f;

    MarchingCubes( 0 );
   }
