#!/bin/bash
set -eu;
readonly ROOT="$(realpath "$(dirname "$0")/..")";

pushd .;
cd ""${ROOT}"";

printf "This script requires the \"aseprite\" binary in the path.\\n";
aseprite ""${ROOT}"/src/hourglass.aseprite" --batch --crop 0,0,36,4 --layer "Layer 2" --frame-range 0,0 --save-as ""${ROOT}"/export/hourglass.gif";
for i in $(seq 0 3);
do
    aseprite ""${ROOT}"/src/hourglass.aseprite" --batch --crop 11,0,14,36 --layer "Sand" --frame-range "${i}","${i}" --save-as ""${ROOT}"/export/hourglass__sand__frame_"${i}".gif";
done;

popd;
