#!/bin/bash
set -eu;
readonly ROOT="$(realpath "$(dirname "$0")/..")";

pushd .;
cd "${ROOT}";

""${ROOT}"/cardreal/build.sh";
mkdir -p ""${ROOT}"/cardbridge/build/org";
cp -ar ""${ROOT}"/cardreal/build/org" ""${ROOT}"/cardbridge/build";

cd ""${ROOT}"/cardbridge";

javac --class-path ""${ROOT}"/cardbridge/build" -d ""${ROOT}"/cardbridge/build" ""${ROOT}"/cardbridge/Bridge.java";
javac --class-path ""${ROOT}"/cardbridge/build" -d ""${ROOT}"/cardbridge/build" ""${ROOT}"/cardbridge/javacard/framework/Util.java";
cd ""${ROOT}"/cardbridge/build";
jar cmf ""${ROOT}"/cardbridge/Bridge.mf" "Bridge.jar" "Bridge.class" "org/_1935711/gosia/Gfx.class" \
    "org/_1935711/gosia/A0.class" \
    "org/_1935711/gosia/A1.class" \
    "org/_1935711/gosia/A2.class" \
    "org/_1935711/gosia/A3.class" \
    "org/_1935711/gosia/A4.class" \
    "javacard/framework/Util.class" \
    ;

popd;
