#!/bin/bash
set -eu;

readonly ROOT="$(realpath "$(dirname "$0")/..")";
pushd .;
cd "${ROOT}";

pushd .;
cd "${ROOT}"/host;
zig build -Doptimize=Debug;
popd;

pushd .;
cd "${ROOT}"/cardemu;
zig build -Doptimize=Debug;
popd;

""${ROOT}"/cardbridge/build.sh";

touch ""${ROOT}"/cardemu/0.capdu";
touch ""${ROOT}"/cardemu/0.rapdu";

( \
    echo "java -jar ""${ROOT}"/cardbridge/build/Bridge.jar" ""${ROOT}"/cardemu/0.capdu" ""${ROOT}"/cardemu/0.rapdu""; \
    echo """${ROOT}"/cardemu/zig-out/bin/gosia__gfx__cardemu" --log-path ""${ROOT}"/cardemu/0.log" --fs-load-path ""${ROOT}"/cardemu/swsim/data/usim.json" --fs-save-path ""${ROOT}"/cardemu/0.swiccfs" --capdu-path ""${ROOT}"/cardemu/0.capdu" --rapdu-path ""${ROOT}"/cardemu/0.rapdu""; \
    echo "sleep 2; ""${ROOT}"/host/zig-out/bin/gosia__gfx__host" --log-path ""${ROOT}"/host/host.log" --card-gfx-0 'swICC PC/SC IFD Driver v1.2.0 00 00'"\
) | parallel;

popd;
