#!/bin/bash
set -eu;
readonly ROOT="$(realpath "$(dirname "$0")")";

readonly GFX_KIC="${1:?Argument 1 is missing: Expected KIC1 of the GFX card.}";
readonly GFX_KID="${2:?Argument 2 is missing: Expected KID1 of the GFX card.}";
readonly GFX_KIK="${3:?Argument 3 is missing: Expected KIK1 of the GFX card.}";

readonly MSX_KIC="${4:?Argument 4 is missing: Expected KIC1 of the MSX card.}";
readonly MSX_KID="${5:?Argument 5 is missing: Expected KID1 of the MSX card.}";
readonly MSX_KIK="${6:?Argument 6 is missing: Expected KIK1 of the MSX card.}";

pushd .;
cd "${ROOT}";

mkdir -p ./script;

if [ ! -f ./script/install__gfx.pysim ]; then
sed "s/{{KIK}}/${GFX_KIK}/" ./script__template/install.pysim \
    | sed "s/{{KIC}}/${GFX_KIC}/" \
    | sed "s/{{KID}}/${GFX_KID}/" \
    | sed "s/{{CAP}}/GosiaGfx.cap/" \
    > ./script/install__gfx.pysim;
fi

if [ ! -f ./script/install__msx.pysim ]; then
sed "s/{{KIK}}/${MSX_KIK}/" ./script__template/install.pysim \
    | sed "s/{{KIC}}/${MSX_KIC}/" \
    | sed "s/{{KID}}/${MSX_KID}/" \
    | sed "s/{{CAP}}/GosiaMsx.cap/" \
    > ./script/install__msx.pysim;
fi

popd;
