#!/bin/bash
set -eu;

readonly ROOT="$(realpath "$(dirname "$0")")";
pushd .;
cd "${ROOT}";

rm -r ./release || true;
mkdir ./release;

pushd .;
cd ./asset;
./convert.sh;
for i in $(seq 1 5); do
    cp "./export/msx__"${i}".u8" ""${ROOT}"/release/";
done;
popd;

pushd .;
cd ./gfx/cardreal;
./build.sh;
cp ./dist/GosiaGfx.cap ""${ROOT}"/release/";
popd;

pushd .;
cd ./msx/cardreal;
./build.sh;
cp ./dist/GosiaMsx.cap ""${ROOT}"/release/";
popd;

pushd .;
cd ./gfx/host;
zig build -Doptimize=ReleaseSmall;
cp ./zig-out/bin/gosia__gfx__host ""${ROOT}"/release/";
popd;

pushd .;
cd ./release;
readonly RELEASE__SIZE=$(( $(stat -c%s "./GosiaGfx.cap") + $(stat -c%s "./GosiaMsx.cap") + $(stat -c%s "msx__1.u8") + $(stat -c%s "msx__2.u8") + $(stat -c%s "msx__3.u8") + $(stat -c%s "msx__4.u8")+$(stat -c%s "msx__5.u8") ));
ls -l .;
printf "Release size: %u Bytes\\n" ${RELEASE__SIZE};
popd;


popd;
