        ; NO SERVICE - 256b - Atari 2600 - dihalt 2o25 summer
        ; --artёmka 1o.o7.2o25

        ; additional thanks to Natt for tips and code snippets ;)
        ; also yea that's my first 6502 code! done in roughly 10 hours

        ; greetings to all sizecoders, fuckings to those who screws telecom up =)

        ; use 64tass to compile, don't forget the -b flag! 
        ; add any padding to the beginning if your (flash)cart/emu can't load short .bin's

        .include "hw.asm"

        ; ram stuff
        *=$80
ram_start:
frame:  .byte ?
state:  .byte ?
p1mask: .byte ?
y_ofs:  .byte ?
ram_end:

V_SYNC_LEN        = 3
V_FRONT_PORCH     = 37-12
V_ACTIVE_LINES    = 192+12+20
V_BACK_PORCH      = 30-20
CELL_PIXELS       = 8
CELL_PIXEL_HEIGHT = 8

        ; ---------------------------
        ; code start
        *=$FF00
start:
        ; init 6502 regs
        sei
        cld

        ; tia clear routine https://github.com/akumanatt/2600-wordle/blob/main/src/main.asm#L116
        lda     #0
        ldx     #(PF2-NUSIZ0)
-       sta     NUSIZ0,x
        dex
        bne     -
        ldx     #(RESMP1-AUDC0)
-       sta     AUDC0,x
        dex
        bne     -
        ldx     #(ram_end-ram_start)
-       sta     ram_start, x
        dex 
        bne     -

        lda     #31
        sta     AUDF1
        lda     #8
        sta     AUDC1

        ; set position
        lda     #(7 + (3 << 4))
        sta     WSYNC
        sta     NUSIZ0
        sta     NUSIZ1

frame_loop:
        ; VSYNC (3 lines)
        lda     #2
        sta     WSYNC
        sta     VSYNC

        sta     WSYNC
        ; reposition P1/P2
        sta     WSYNC
        ldx     #7
-       dex
        bne     -
        sta     RESP0
        jmp     +
+       jmp     +
+       sta     RESP1

        ; -----------------
        ; blank
        lda     #0
        sta     VSYNC

        ; front porch (37 lines)
        ldy     #V_FRONT_PORCH
front_porch:
        sta     WSYNC
        dey
        bne     front_porch
        sty     VBLANK

        ; top border
        ldy     #((V_ACTIVE_LINES-(CELL_PIXELS*CELL_PIXEL_HEIGHT))/2)
border_top:
        tya
        jsr     gligli
        dey
        bne     border_top

        ; "МТС - на шаг впереди" (или позади, смотря куда посмотреть)
        ldx     #CELL_PIXELS
cell_loop:
        sta     WSYNC
        sta     HMOVE
        lda     cell-1, x
        sta     GRP0
        lda     signal-1, x
        and     p1mask
        sta     GRP1

        ldy     #CELL_PIXEL_HEIGHT-1
cell_inner:
        jsr     gligli
        dey
        bne     cell_inner
        dex
        bne     cell_loop

        ldy     #((V_ACTIVE_LINES-(CELL_PIXELS*CELL_PIXEL_HEIGHT))/2)
        lda     #0
        sta     GRP1
        sta     GRP0
        ldx     p1mask
        bne     nogl
        ldx     frame
        lda     $FF00,x
nogl:
        sta     HMP0

        ; bottom border
        border_bottom:
        tya
        jsr     gligli
        dey
        bne     border_bottom

        ; back porch (30 lines)
        lda     #2
        sta     VBLANK
        ldy     #V_BACK_PORCH
back_porch:
        sta     WSYNC
        dey
        bne     back_porch

        inc     frame
        bne     frame_loop

        ldx     state
        lda     p1mask_bin, x
        sta     p1mask
        lda     colp0_bin, x
        sta     COLUP0
        lda     colp1_bin, x
        sta     COLUP1
        stx     state
        cpx     #4
        beq     skip_reset_state
        inc     state
skip_reset_state:
        txa
        sta     AUDV1
        adc     #1
        rol     a
        sta     AUDC0
        sta     AUDV0
        jmp     frame_loop

gligli:
        tya
        eor     frame
        pha
        and     #12
        sta     WSYNC
        sta     AUDF0
        pla
        and     state
        sta     COLUBK
        rts

cell:
        .byte   %00010000
        .byte   %00010000
        .byte   %00010000
        .byte   %00010000
        .byte   %00111000
        .byte   %01010100
        .byte   %10010010
        .byte   %11111110

signal:
        .byte   %10101010
        .byte   %10101010
        .byte   %00101010
        .byte   %00101010
        .byte   %00001010
        .byte   %00001010
        .byte   %00000010
        .byte   %00000010

        ; 5 states
p1mask_bin:
        .byte   %11111111
        .byte   %11111100
        .byte   %11110000
        .byte   %11000000
        .byte   %00000000

colp0_bin:
        .byte   $0E
        .byte   $0E
        .byte   $1C
        .byte   $3E
        .byte   $48

colp1_bin:
        .byte   $C6
        .byte   $D6
        .byte   $E6
        .byte   $36
        .byte   $00

        ; reset vectors and stuff
        *=$FFFA
        .word start           ; NMI 
        .word start           ; RESET 
        .word start           ; IRQ 
        