/*
 * Decompiled with CFR 0.152.
 */
package org.kd.tricks;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import java.util.stream.IntStream;
import org.kd.common.Scene;

public final class TrickScene1
extends Scene {
    public SpriteBatch batch2;
    private ShapeRenderer shapeRenderer;
    private float sineWidth = 20.0f;
    private float xExit = 0.0f;
    private Color topColor = new Color(0.0f, 0.0f, 0.5f, 1.0f);
    private Color bottomColor = new Color(0.4f, 0.7f, 1.0f, 1.0f);

    public TrickScene1() {
        super("trick-scene1");
    }

    @Override
    public void create() {
        this.shapeRenderer = new ShapeRenderer();
        this.batch2 = new SpriteBatch();
    }

    @Override
    public void update(float delta) {
        long frame = Gdx.graphics.getFrameId();
        System.out.print(" fr=" + frame + " ");
        double x = (double)((float)(frame + 400L) / 1000.0f) * 3.14;
        this.topColor.b = (float)Math.abs(Math.sin(x));
        this.sineWidth = (float)(23.0 + 12.0 * Math.cos(x / 3.0));
        this.conditionalExit();
    }

    @Override
    public void render() {
        long frame = Gdx.graphics.getFrameId();
        this.shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
        this.shapeRenderer.rect(0.0f, 0.0f, Gdx.graphics.getWidth(), Gdx.graphics.getHeight(), this.topColor, this.topColor, this.bottomColor, this.bottomColor);
        this.shapeRenderer.end();
        this.shapeRenderer.begin(ShapeRenderer.ShapeType.Line);
        for (float y = 0.0f; y < (float)Gdx.graphics.getHeight(); y += 1.0f) {
            this.shapeRenderer.setColor(Color.BLACK);
            float x2 = (float)(100.0 + 50.0 * Math.sin((double)y / Math.PI / (double)this.sineWidth) + 20.0 * Math.sin(0.9 * (double)y / 15.0));
            float xLeft = x2 + this.xExit;
            this.shapeRenderer.line(0.0f, y, xLeft, y);
            this.shapeRenderer.line(Gdx.graphics.getWidth(), (float)Gdx.graphics.getHeight() - y, (float)Gdx.graphics.getWidth() - x2 - this.xExit, (float)Gdx.graphics.getHeight() - y);
        }
        if (frame > 1000L) {
            this.randomStars();
        }
        this.shapeRenderer.end();
    }

    private boolean conditionalExit() {
        long frame = Gdx.graphics.getFrameId();
        if (this.xExit > (float)Gdx.graphics.getWidth() / 2.0f) {
            return false;
        }
        if (frame > 1000L) {
            this.xExit += 1.0f;
        }
        return true;
    }

    private void randomStars() {
        this.shapeRenderer.setColor(Color.WHITE);
        int w = Gdx.graphics.getWidth();
        float x = (float)((double)this.xExit * Math.random());
        int h = Gdx.graphics.getHeight();
        float y = (float)((double)(h / 3) * Math.random());
        int amount = 33;
        IntStream.range(0, amount).forEach(j -> {
            double i = (float)Math.min(w, h) / (float)amount * (float)j;
            this.shapeRenderer.rect((float)((double)(x / 11.0f) + i * Math.random()), (float)((double)y + i * Math.random()), 1.0f, 1.0f);
            this.shapeRenderer.rect((float)w - (float)((double)x + i / 11.0 * Math.random()), (float)((double)y + i * Math.random()), 1.0f, 1.0f);
            this.shapeRenderer.rect((float)w - (float)((double)x + i / 11.0 * Math.random()), (float)h - (float)((double)y + i * Math.random()), 1.0f, 1.0f);
        });
    }

    @Override
    public void dispose() {
        this.shapeRenderer.dispose();
    }
}

