org   16514   
	defb   $02,$51,$30,$72,$09,$04,$92,$49   
start:              	; Prefix the code with the bitmap data
        push bc     	; At startup “start” is in BC
        pop hl      	; so move it to HL, use as bitmap pointer
        ld b, 9     	; start on the 9th row
row:                	
        ld c, 9     	; start each row on the 9th column, and first
loop:               	; plot 4 asterisks
        push hl     	; save HL as it gets used to print
        push bc     	; save BC as it gets destroyed 
        call $8f5   	; point HL at (c,b)
        pop bc      	; retrieve BC
        ld a,18     	; load rotation constant
        cp (hl)     	; use it to check if all 4 plots are done
        ld (hl),23  	; plot a *
        pop hl      	; retrieve HL
        jr c, xloop 	; if all 4 plots already done, x-it the loop 
        sub c       	; otherwise A = 18-C
        ld c,b      	; C = B
        ld b,a      	; B = 18-C => rotate 90º
        jr nz, loop 	; If row != 0 then continue rotating
        ret         	; otherwise we are done
xloop:              	
        dec c       	; move on to next column 
        srl (hl)    	; grab 1 bit from bitmap
        jr c, loop  	; if bit set then plot it
        jr nz, xloop	; if more bits remain, keep getting them
        dec b       	; otherwise, move on to next row
        dec hl      	; iterate bitmap pointer
        jr row      	; print the next row
