
#version 430 core
out vec4 FragColor;

uniform sampler2D source0;
uniform sampler2D source1;
uniform vec4 source0_window; // x, y, width, height
uniform vec4 source1_window; // x, y, width, height
uniform vec4 target_window; // x, y, width, height
uniform vec4 blend;

void main()
{
    //FragColor = vec4(1.0f, 0.0f, 0.0f, 1.0f);
    vec2 coord = (gl_FragCoord.xy - target_window.xy) / target_window.zw;
    if (coord.x >= 0.0f && coord.x < 1.0f && 
        coord.y >= 0.0f && coord.y < 1.0f)
    {
        FragColor =
            mix(texelFetch(source0, ivec2(coord*source0_window.zw + source0_window.xy), 0),
                texelFetch(source1, ivec2(coord*source1_window.zw + source1_window.xy), 0),
                blend.x );
    }
    else
    {
        discard;
    }

}