/*
 * Decompiled with CFR 0.152.
 */
package org.kd.common;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;

public class AnimatedSprite {
    Texture spriteSheet;
    Animation<TextureRegion> animation;
    float stateTime;
    float scale = 1.0f;
    int x;
    int y;

    public AnimatedSprite(String path, int frameCount, float frameDuration, int x, int y) {
        this.x = x;
        this.y = y;
        this.spriteSheet = new Texture(path);
        int FRAME_COLS = frameCount;
        int FRAME_ROWS = 1;
        int FRAME_WIDTH = this.spriteSheet.getWidth() / FRAME_COLS;
        int FRAME_HEIGHT = this.spriteSheet.getHeight();
        TextureRegion[][] tmpRegions = TextureRegion.split(this.spriteSheet, FRAME_WIDTH, FRAME_HEIGHT);
        TextureRegion[] frames = new TextureRegion[FRAME_COLS * FRAME_ROWS];
        int index = 0;
        for (int i = 0; i < FRAME_ROWS; ++i) {
            for (int j = 0; j < FRAME_COLS; ++j) {
                frames[index++] = tmpRegions[i][j];
            }
        }
        this.animation = new Animation<TextureRegion>(frameDuration, frames);
        this.stateTime = 0.0f;
    }

    public void draw(SpriteBatch batch) {
        this.stateTime += Gdx.graphics.getDeltaTime();
        TextureRegion currentFrame = this.animation.getKeyFrame(this.stateTime, true);
        batch.draw(currentFrame, (float)this.x, (float)this.y, (float)currentFrame.getRegionWidth() * this.scale, (float)currentFrame.getRegionHeight() * this.scale);
    }

    public void scale(float scaleValue) {
        this.scale = scaleValue;
    }

    public void dispose() {
        this.spriteSheet.dispose();
    }
}

