/*
 * Decompiled with CFR 0.152.
 */
package org.kd.common.tricks;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import org.kd.common.tricks.Rosette;

public class RollerShades {
    private final long startFrame;
    private final long relEndFrame = 750L;
    private final int linesCount;
    private final Color color;

    public RollerShades(long startFrame, Color color, int linesCount) {
        this.startFrame = startFrame;
        this.color = color;
        this.linesCount = Math.max(1, linesCount);
    }

    public void render(ShapeRenderer shapeRen) {
        int fr = Long.valueOf(Gdx.graphics.getFrameId() - this.startFrame).intValue();
        if ((long)fr > 750L) {
            System.out.println(Rosette.class.getSimpleName() + " effect done");
            return;
        }
        float maxX = Gdx.graphics.getWidth();
        float maxY = Gdx.graphics.getHeight();
        shapeRen.setColor(this.color);
        shapeRen.begin(ShapeRenderer.ShapeType.Filled);
        int step = Math.round(maxY / (float)this.linesCount);
        int y = 0;
        while ((float)y < maxY) {
            shapeRen.rect(0.0f, y, 5 * fr, step + 1);
            y += 2 * step;
        }
        y = step;
        while ((float)y < maxY) {
            shapeRen.rect(maxX - (float)(5 * fr), y, 5 * fr, step + 1);
            y += 2 * step;
        }
        shapeRen.end();
    }

    public long getStartFrame() {
        return this.startFrame;
    }
}

