/*
 * Decompiled with CFR 0.152.
 */
package org.kd.common.tricks;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;

public class Rosette {
    private final long startFrame;
    private final long relEndFrame = 250L;
    private final Color color;
    float coeff = 1.0f;

    public Rosette(long startFrame, Color color) {
        this.startFrame = startFrame;
        this.color = color;
    }

    public void render(ShapeRenderer shapeRen) {
        int fr = Long.valueOf(Gdx.graphics.getFrameId() - this.startFrame).intValue();
        if ((long)fr > 250L) {
            System.out.println(Rosette.class.getSimpleName() + " effect done");
            return;
        }
        float maxX = Gdx.graphics.getWidth();
        float maxY = Gdx.graphics.getHeight();
        shapeRen.setColor(this.color);
        shapeRen.begin(ShapeRenderer.ShapeType.Filled);
        shapeRen.triangle(maxX / 2.0f, maxY / 2.0f, 0.0f, 0.0f, this.coeff * (float)fr, 0.0f);
        shapeRen.triangle(maxX / 2.0f, maxY / 2.0f, 0.0f, maxY, this.coeff * (float)fr, maxY);
        shapeRen.triangle(maxX / 2.0f + 1.0f, maxY / 2.0f + 1.0f, 0.0f, this.coeff * (float)fr, 1.0f, 0.0f);
        this.coeff += 0.1f;
        if ((double)(this.coeff * (float)fr) > 1.5 * (double)maxX) {
            this.coeff += 1.0f;
            shapeRen.rect(0.0f, 0.0f, (float)(2 * fr) + 3.0f * this.coeff, maxY);
        }
        if (this.coeff * (float)fr > 3.0f * maxX) {
            this.coeff += 1.0f;
        }
        if ((double)(this.coeff * (float)fr) > 4.5 * (double)maxX) {
            this.coeff += 1.0f;
        }
        if (this.coeff * (float)fr > 5.0f * maxX) {
            this.coeff += 10.0f;
        }
        shapeRen.end();
    }

    public long getStartFrame() {
        return this.startFrame;
    }
}

