/*
 * Decompiled with CFR 0.152.
 */
package org.kd.common.tricks;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import org.kd.tricks.GradientRectangleTrick;

public class WavedEdgeTrick
extends GradientRectangleTrick {
    private float sineWidth = 20.0f;
    private float xExit = 0.0f;
    private static final long TRICK1_GRADUAL_EXIT = 1000L;

    public WavedEdgeTrick(int x1, int y1, int x2, int y2, SpriteBatch batch2, ShapeRenderer shapeRenderer, float sineWidth, float xExit) {
        super(x1, y1, x2, y2, batch2, shapeRenderer);
        this.sineWidth = sineWidth;
        this.xExit = xExit;
    }

    public void update() {
        super.update(false, false, true);
        long frame = Gdx.graphics.getFrameId();
        double x = (double)((float)(frame + 400L) / 1000.0f) * 3.14;
        this.sineWidth = (float)(23.0 + 12.0 * Math.cos(x / 3.0));
        this.conditionalExit();
    }

    public void render() {
        int width = this.x2 - this.x1;
        int height = this.y2 - this.y1;
        this.drawGradientRectangle(this.x1, this.y1, width, height);
        this.drawEdgeWaves();
    }

    private void drawEdgeWaves() {
        this.shapeRenderer.begin(ShapeRenderer.ShapeType.Line);
        for (float yy = (float)this.y1; yy < (float)this.y2; yy += 1.0f) {
            this.shapeRenderer.setColor(Color.BLACK);
            float xx = (float)(100.0 + 50.0 * Math.sin((double)yy / Math.PI / (double)this.sineWidth) + 20.0 * Math.sin(0.9 * (double)yy / 15.0));
            float xLeft = xx + this.xExit;
            this.shapeRenderer.line(this.x1, yy, xLeft + (float)this.x1, yy);
            this.shapeRenderer.line(this.x2, (float)this.y2 - yy + (float)this.y1, (float)this.x2 - xLeft, (float)this.y2 - yy + (float)this.y1 - 1.0f);
        }
        if (this.getRelativeFrame() > 1000L) {
            // empty if block
        }
        this.shapeRenderer.end();
    }

    private boolean conditionalExit() {
        if (this.xExit > (float)Gdx.graphics.getWidth() / 2.0f) {
            return false;
        }
        if (this.getRelativeFrame() > 1000L) {
            this.xExit += 1.0f;
        }
        return true;
    }

    private long getRelativeFrame() {
        long frame = Gdx.graphics.getFrameId();
        return frame - this.initialFrame;
    }
}

