/*
 * Decompiled with CFR 0.152.
 */
package org.kd.common.tricks.snakeseg;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import java.util.ArrayList;
import java.util.List;

public class SnakeSegments {
    private final float segmentRadius;
    private final List<Segment> segments;

    public SnakeSegments(int segmentCount) {
        this(segmentCount, 40.0f);
    }

    public SnakeSegments(int segmentCount, float segmentRadius) {
        this.segmentRadius = segmentRadius;
        this.segments = new ArrayList<Segment>(segmentCount);
        for (int i = 0; i < segmentCount; ++i) {
            Segment s = new Segment(segmentRadius + (float)i * segmentRadius * 2.0f, segmentRadius);
            this.segments.add(s);
        }
    }

    public void move(float dx, float dy) {
        for (int i = 0; i < this.segments.size() - 1; ++i) {
            Segment s1 = this.segments.get(i);
            Segment s2 = this.segments.get(i + 1);
            float middlePointX = (s1.x + s2.x) / 2.0f;
            float middlePointY = (s1.y + s2.y) / 2.0f;
            s2.moveTowards(middlePointX, middlePointY);
        }
        this.segments.get(0).moveTowards(dx, dy);
    }

    public void render(ShapeRenderer shapeRenderer) {
        shapeRenderer.begin(ShapeRenderer.ShapeType.Line);
        shapeRenderer.setColor(Color.DARK_GRAY);
        shapeRenderer.circle(this.segments.get((int)0).x, this.segments.get((int)0).y, this.segmentRadius);
        shapeRenderer.setColor(Color.WHITE);
        for (int i = 1; i < this.segments.size(); ++i) {
            shapeRenderer.circle(this.segments.get((int)i).x, this.segments.get((int)i).y, this.segmentRadius);
        }
        shapeRenderer.end();
    }

    private static class Segment {
        public float x;
        public float y;

        Segment(float x, float y) {
            this.x = x;
            this.y = y;
        }

        public void moveTowards(float xDest, float yDest) {
            double speed = 0.1;
            float dx = xDest - this.x;
            float dy = yDest - this.y;
            double angle = Math.atan2(dy, dx);
            double d = Math.sqrt(dx * dx + dy * dy) * speed;
            this.x = (float)((double)this.x + d * Math.cos(angle));
            this.y = (float)((double)this.y + d * Math.sin(angle));
        }
    }
}

