/*
 * Decompiled with CFR 0.152.
 */
package org.kd.goodjob;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import org.kd.common.ConsoleLogger;
import org.kd.common.Demo;
import org.kd.common.Scene;
import org.kd.common.tricks.AlphabetScroll;
import org.kd.goodjob.appendix.BannerTombstone;
import org.kd.tricks.GradientLines;

public final class Scene4JobsReturn
extends Scene {
    public static final long START_FRAME = 8187L;
    private SpriteBatch batch4;
    private Sprite comebackPic;
    private Sprite jobs;
    private Sprite mac1;
    private Sprite mac2;
    private Sprite wallpaper;
    private Sprite timCook;
    private Sprite timCookAscii;
    private Texture tombstone;
    private Texture iMac;
    private Texture iPod;
    private Texture iPad;
    private Texture iPhone;
    private Texture appleTV;
    private Texture aplleWatch;
    private Texture iCloud;
    private GradientLines backgroundLinesTrick;
    private AlphabetScroll scroll;

    public Scene4JobsReturn() {
        super("4.Jobs Returns");
    }

    @Override
    public void create() {
        this.batch4 = new SpriteBatch();
        Texture comebackTxtr = new Texture("good-job/bigComeback.png");
        this.comebackPic = new Sprite(comebackTxtr);
        int W = Gdx.graphics.getWidth();
        int H = Gdx.graphics.getHeight();
        this.comebackPic.setPosition((float)W / 8.0f, (float)H / 4.0f);
        Texture jobsTxtr = new Texture("good-job/JobsComeback/jobs.png");
        this.jobs = new Sprite(jobsTxtr);
        this.jobs.setScale(0.65f);
        Texture macTexture = new Texture("good-job/macintosh/makintosz.png");
        this.mac1 = new Sprite(macTexture);
        float macY = 61.0f;
        this.mac1.setPosition(11.0f, macY);
        this.mac2 = new Sprite(macTexture);
        this.mac2.flip(true, false);
        this.mac2.setPosition((float)W * 0.81f, macY);
        Texture wallpaperTexture = new Texture("good-job/wallpaper.png");
        float wallpaperX = (float)W / 2.0f - (float)wallpaperTexture.getWidth() / 2.0f;
        float wallpaperY = (float)H / 2.0f - (float)wallpaperTexture.getHeight() / 2.0f;
        this.wallpaper = new Sprite(wallpaperTexture);
        this.wallpaper.setPosition(wallpaperX, wallpaperY);
        this.timCookAscii = new Sprite(new Texture("good-job/JobsComeback/timCookAscii.png"));
        this.timCook = new Sprite(new Texture("good-job/JobsComeback/timCook.png"));
        this.tombstone = new Texture("good-job/tombstone/tombstone.png");
        this.iMac = new Texture("good-job/iMac.png");
        this.iPod = new Texture("good-job/iPod.png");
        this.iPad = new Texture("good-job/iPad.png");
        this.iPhone = new Texture("good-job/iPhone.png");
        this.aplleWatch = new Texture("good-job/JobsComeback/appleWatch.png");
        this.appleTV = new Texture("good-job/JobsComeback/AppleTV.png");
        this.iCloud = new Texture("good-job/JobsComeback/iCloud.jpg");
        this.backgroundLinesTrick = new GradientLines(new ShapeRenderer(), Math.round((float)W / 4.0f), Math.round((float)H / 4.0f), Math.round(3.0f * (float)W / 4.0f), Math.round(3.0f * (float)H / 4.0f), Color.BLACK);
        String scrollText = "After returning to apple  Steve Jobs spearheaded the launch of the imac  revitalizing the company design and technology  and led the development of groundbreaking products like ipod  iphone and ipad transforming multiple industries   He continued to innovate until his death  leaving a lasting legacy  Tim Cook took over apple and continued Jobs vision creating AppleWatch AppleTV and iCloud";
        this.scroll = new AlphabetScroll(scrollText.toLowerCase(), 8667L);
        this.scroll.setShiftY(81.0f);
        this.scroll.scale(0.7f);
    }

    @Override
    public void update(float delta) {
        if (240L < this.getRelativeFrame() && this.getRelativeFrame() < 4900L) {
            if (this.getRelativeFrame() % 3L == 1L) {
                float newScale = Math.min(1.0f, this.jobs.getScaleX()) + 0.01f;
                this.jobs.setScale(newScale);
            }
            if (this.getRelativeFrame() % 2L == 0L) {
                this.scroll.update();
            }
            if (3300L < this.getRelativeFrame() && this.getRelativeFrame() < 3800L && Demo.logging) {
                ConsoleLogger.logBannerWithElapsedTime(BannerTombstone.lines);
            }
        }
    }

    @Override
    public void render() {
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.batch4.begin();
        int W = Gdx.graphics.getWidth();
        int H = Gdx.graphics.getHeight();
        if (this.getRelativeFrame() < 800L) {
            this.drawJobs(W, H);
        } else if (this.getRelativeFrame() < 3800L) {
            this.drawiMaciPodiPhone(W, H);
        } else {
            this.drawWatchTvCloud(W, H);
        }
        if (3300L < this.getRelativeFrame() && this.getRelativeFrame() < 3750L) {
            this.batch4.draw(this.tombstone, (float)W / 2.0f - 265.0f, (float)H * 0.255f);
        }
        if (this.getRelativeFrame() < 240L) {
            this.comebackPic.draw(this.batch4);
        } else {
            this.scroll.render(this.batch4);
            this.mac1.draw(this.batch4);
            this.mac2.draw(this.batch4);
        }
        this.batch4.end();
    }

    private void drawWatchTvCloud(int W, int H) {
        if (this.getRelativeFrame() < 4000L) {
            this.timCookAscii.draw(this.batch4);
            this.timCookAscii.setPosition(-this.timCookAscii.getWidth() / 2.0f + (float)W / 2.0f, -this.timCookAscii.getHeight() / 2.0f + (float)H / 2.0f);
        } else if (this.getRelativeFrame() < 4200L) {
            this.timCook.setScale(1.7f);
            this.timCook.draw(this.batch4);
            this.timCook.setPosition(-this.timCook.getWidth() / 2.0f + (float)W / 2.0f, -this.timCook.getHeight() / 2.0f + (float)H / 2.0f);
        }
        this.batch4.end();
        if (this.getRelativeFrame() > 4200L) {
            this.backgroundLinesTrick.draw(6);
        }
        this.batch4.begin();
        if (this.getRelativeFrame() > 4200L) {
            this.wallpaper.draw(this.batch4);
            if (4200L < this.getRelativeFrame() && this.getRelativeFrame() < 4300L) {
                this.timCook.setPosition(-this.timCook.getWidth() / 2.0f + (float)W / 2.0f, -this.timCook.getHeight() / 2.0f - (float)H / 2.0f);
                this.timCook.draw(this.batch4);
            } else if (4300L < this.getRelativeFrame() && this.getRelativeFrame() < 4380L) {
                this.batch4.draw(this.aplleWatch, (float)W / 2.0f - (float)this.aplleWatch.getWidth() / 2.0f, (float)H / 3.95f);
            } else if (4381L < this.getRelativeFrame() && this.getRelativeFrame() < 4441L) {
                this.batch4.draw(this.appleTV, (float)W / 2.0f - (float)this.appleTV.getWidth() / 2.0f, (float)H / 3.95f);
            } else if (4441L < this.getRelativeFrame() && this.getRelativeFrame() < 4570L) {
                this.batch4.draw(this.iCloud, (float)W / 2.0f - (float)this.iCloud.getWidth() / 2.0f, (float)H / 3.95f);
            }
        }
    }

    private void drawJobs(int W, int H) {
        float jobsX = (float)W / 2.0f - this.jobs.getWidth() / 2.0f;
        float jobsY = (float)H - this.jobs.getHeight() - 2.0f;
        this.jobs.setPosition(jobsX, jobsY);
        this.jobs.draw(this.batch4);
    }

    private void drawiMaciPodiPhone(int W, int H) {
        this.batch4.end();
        if (this.getRelativeFrame() < 3300L) {
            this.backgroundLinesTrick.draw(6);
        }
        this.batch4.begin();
        if (this.getRelativeFrame() < 3300L) {
            this.wallpaper.draw(this.batch4);
        }
        if (1400L < this.getRelativeFrame() && this.getRelativeFrame() < 1900L) {
            this.batch4.draw(this.iMac, (float)W / 2.0f - (float)this.iMac.getWidth() / 2.0f, (float)H / 3.95f);
        } else if (2300L < this.getRelativeFrame() && this.getRelativeFrame() < 2400L) {
            this.batch4.draw(this.iPod, (float)W / 2.0f - (float)this.iPod.getWidth() / 2.0f, (float)H / 3.95f);
        } else if (2415L < this.getRelativeFrame() && this.getRelativeFrame() < 2515L) {
            this.batch4.draw(this.iPhone, (float)W / 2.0f - (float)this.iPhone.getWidth() / 2.0f, (float)H / 3.95f);
        } else if (2520L < this.getRelativeFrame() && this.getRelativeFrame() < 2840L) {
            this.batch4.draw(this.iPad, (float)W / 2.0f - (float)this.iPad.getWidth() / 2.0f, (float)H / 3.95f);
        }
    }

    @Override
    public void dispose() {
        this.batch4.dispose();
    }

    private long getRelativeFrame() {
        long frame = Gdx.graphics.getFrameId();
        return frame - 8187L;
    }
}

