/*
 * Decompiled with CFR 0.152.
 */
package org.kd.goodjob;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import org.kd.common.AnimatedSprite;
import org.kd.common.C64Helper;
import org.kd.common.ConsoleLogger;
import org.kd.common.Demo;
import org.kd.common.Scene;
import org.kd.common.tricks.Effects;
import org.kd.goodjob.appendix.BannerApple;
import org.lwjgl.util.Point;

public final class Scene5Exit
extends Scene {
    public static final long START_FRAME = 13087L;
    static final long DEMO_END_FRAME = 14716L;
    private SpriteBatch batch5;
    private Texture cake;
    private BitmapFont font;
    private BitmapFont fontSmall;
    private final List<Message> messages;
    private Music endSpeech;
    private final List<AnimatedSprite> flameSprites;

    public Scene5Exit() {
        super("exit");
        List<Point> coords = List.of(new Point(36, 550), new Point(182, 528), new Point(370, 560), new Point(648, 523), new Point(939, 500));
        int spriteCount = coords.size();
        this.flameSprites = new ArrayList<AnimatedSprite>(spriteCount);
        IntStream.range(0, spriteCount).forEach(i -> {
            int x = ((Point)coords.get(i)).getX();
            int y = ((Point)coords.get(i)).getY();
            AnimatedSprite flame = new AnimatedSprite("good-job/flames/flame.png", 4, 0.05f + 0.008f * (float)i, x, y);
            flame.scale(1.0f - 0.05f * (float)i);
            if (List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2)).contains(i)) {
                flame.scale(0.54f);
            }
            this.flameSprites.add(flame);
        });
        this.messages = new ArrayList<Message>();
        this.messages.add(new Message("This demo is not intended as an advertisement of Apple company", 121));
        this.messages.add(new Message("But as a tribute to a great man, who created a great firm.", 391));
        this.messages.add(new Message("IT is a dynamic environment, and hardly any company is able ", 612));
        this.messages.add(new Message("to stay 50 years on a market...", 870));
        this.messages.add(new Message("and thrive.", 991));
    }

    @Override
    public void create() {
        this.batch5 = new SpriteBatch();
        this.cake = new Texture("good-job/cake.jpg");
        this.font = C64Helper.createFont(44, "DRENA.ttf");
        this.fontSmall = C64Helper.createFont(22, "Helvetica Regular.otf");
        this.endSpeech = Gdx.audio.newMusic(Gdx.files.internal("good-job/end-speech.mp3"));
    }

    @Override
    public void update(float delta) {
        if (Demo.logging) {
            ConsoleLogger.logBannerWithElapsedTime(BannerApple.lines);
        }
    }

    @Override
    public void render() {
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.batch5.begin();
        this.batch5.draw(this.cake, 0.0f, 0.0f);
        this.flameSprites.forEach(flame -> flame.draw(this.batch5));
        if (this.getRelativeFrame() == 122L) {
            this.endSpeech.play();
        }
        if (this.getRelativeFrame() > 122L) {
            int baseY = Gdx.graphics.getHeight() - 30;
            int lineSpacing = 57;
            for (int i = 0; i < this.messages.size(); ++i) {
                Message msg = this.messages.get(i);
                if (this.getRelativeFrame() <= (long)msg.frameThreshold) continue;
                int yPosition = baseY - i * lineSpacing;
                this.font.draw((Batch)this.batch5, msg.text, 30.0f, (float)yPosition);
            }
            if (Gdx.graphics.getFrameId() > 14466L) {
                this.fontSmall.draw((Batch)this.batch5, "CODE & GFX: KD ", 0.85f * (float)Gdx.graphics.getWidth(), (float)(this.cake.getHeight() - 60));
                this.fontSmall.draw((Batch)this.batch5, "MSX: RAMOS ", 0.85f * (float)Gdx.graphics.getWidth(), (float)(this.cake.getHeight() - 80));
            }
            Effects.typewriter(this.batch5, this.font, 30.0f, Gdx.graphics.getHeight() - 57 * this.messages.size() - 28, 14416L, 60L, "GOOD JOB MR. JOBS !!! !!! !!! !!! !!! !!! !!! !!! !!!", 1);
        }
        this.batch5.end();
    }

    private long getRelativeFrame() {
        long frame = Gdx.graphics.getFrameId();
        return frame - 13087L;
    }

    @Override
    public void dispose() {
    }

    static class Message {
        String text;
        int frameThreshold;

        Message(String text, int frameThreshold) {
            this.text = text;
            this.frameThreshold = frameThreshold;
        }
    }
}

