/*
 * Decompiled with CFR 0.152.
 */
package org.kd.kickass;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import org.kd.common.AnimatedSpriteV;
import org.kd.common.tricks.RollerShades;
import org.kd.common.tricks.TravellingLogo;

public class Scene2Karateka
implements Screen {
    static final long START_FRAME = 3550L;
    private TravellingLogo logo;
    private TravellingLogo wallpaper;
    private SpriteBatch batch;
    private AnimatedSpriteV karateka;
    private RollerShades shades;
    private ShapeRenderer shapeRenderer;

    @Override
    public void show() {
        float X = (float)Gdx.graphics.getWidth() / 2.0f;
        float Y = Gdx.graphics.getHeight() - 60;
        Texture texture = new Texture("kickass/ka.png");
        this.logo = new TravellingLogo(texture, 1700.0f, Y, 721.0f, 50.0f);
        this.batch = new SpriteBatch();
        this.karateka = new AnimatedSpriteV("kickass/karateka4.png", 53, 0.05f, Math.round(X - 200.0f), 1);
        this.karateka.scale(3.0f);
        Texture texture2 = new Texture("kickass/karateksa.jpg");
        this.wallpaper = new TravellingLogo(texture2, 1.0f, 0.0f, 3500.0f, 990.0f);
        this.wallpaper.spriteSpeed = 2.0f;
        this.shapeRenderer = new ShapeRenderer();
        this.shades = new RollerShades(3980L, Color.BLACK, 11);
    }

    @Override
    public void render(float v) {
        Gdx.gl.glClear(16384);
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        this.update();
        this.batch.begin();
        this.logo.draw(this.batch, 3400, 990);
        this.logo.spriteSpeed = 700.0f;
        this.wallpaper.draw(this.batch, 3400, 990);
        this.wallpaper.spriteSpeed = 700.0f;
        this.karateka.draw(this.batch);
        this.batch.end();
        long frame = Gdx.graphics.getFrameId();
        if (frame > this.shades.getStartFrame()) {
            this.shades.render(this.shapeRenderer);
        }
    }

    private void update() {
        float newScale;
        float delta = Gdx.graphics.getDeltaTime();
        this.logo.move(delta, 1700);
        this.wallpaper.move(delta / 5.0f, 1700);
        long limit = 565L;
        if (this.getCurrentFrame() > limit && (newScale = 3.0f + (float)(this.getCurrentFrame() - limit) * 0.0021f) > 0.0f) {
            this.karateka.scale(newScale);
        }
    }

    private long getCurrentFrame() {
        return Gdx.graphics.getFrameId() - 3550L;
    }

    @Override
    public void resize(int i, int i1) {
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
    }

    @Override
    public void dispose() {
    }
}

