/*
 * Decompiled with CFR 0.152.
 */
package org.kd.threed.adapters;

import com.badlogic.gdx.ApplicationAdapter;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.graphics.g3d.Environment;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.ModelBatch;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.RenderableProvider;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.utils.CameraInputController;
import com.badlogic.gdx.graphics.g3d.utils.ModelBuilder;

public class CubeAnimation
extends ApplicationAdapter {
    private PerspectiveCamera camera;
    private ModelBatch modelBatch;
    private Model model;
    private ModelInstance instance;
    private ModelInstance contourInstance;
    private Environment environment;
    private CameraInputController camController;

    @Override
    public void create() {
        this.camera = new PerspectiveCamera(67.0f, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        this.camera.position.set(0.0f, 0.0f, 300.0f);
        this.camera.lookAt(0.0f, 0.0f, 0.0f);
        this.camera.near = 1.0f;
        this.camera.far = 1000.0f;
        this.camera.update();
        this.camController = new CameraInputController(this.camera);
        Gdx.input.setInputProcessor(this.camController);
        this.modelBatch = new ModelBatch();
        ModelBuilder modelBuilder = new ModelBuilder();
        Material material = new Material(ColorAttribute.createDiffuse(0.0f, 0.5f, 1.0f, 1.0f));
        this.model = modelBuilder.createBox(100.0f, 100.0f, 100.0f, material, 9L);
        this.instance = new ModelInstance(this.model);
        Material contourMaterial = new Material(ColorAttribute.createDiffuse(1.0f, 0.5f, 0.0f, 1.0f));
        Model contourModel = modelBuilder.createBox(111.0f, 111.0f, 111.0f, contourMaterial, 9L);
        this.contourInstance = new ModelInstance(contourModel);
        this.environment = new Environment();
    }

    @Override
    public void render() {
        this.camController.update();
        Gdx.gl.glClearColor(0.1f, 0.7f, 0.1f, 1.0f);
        Gdx.gl.glClear(16640);
        float delta = Gdx.graphics.getDeltaTime();
        this.instance.transform.rotate(0.0f, 1.0f, 0.0f, 30.0f * delta);
        this.contourInstance.transform.rotate(0.0f, 1.0f, 0.0f, 30.0f * delta);
        this.modelBatch.begin(this.camera);
        this.modelBatch.render((RenderableProvider)this.contourInstance, this.environment);
        this.modelBatch.render((RenderableProvider)this.instance, this.environment);
        this.modelBatch.end();
    }

    @Override
    public void dispose() {
        this.modelBatch.dispose();
        this.model.dispose();
    }
}

