/*
 * Decompiled with CFR 0.152.
 */
package org.kd.threed.adapters;

import com.badlogic.gdx.ApplicationAdapter;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Environment;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.ModelBatch;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.RenderableProvider;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.TextureAttribute;
import com.badlogic.gdx.graphics.g3d.environment.DirectionalLight;
import com.badlogic.gdx.graphics.g3d.utils.ModelBuilder;
import com.badlogic.gdx.math.Vector3;
import org.kd.common.C64Colors;

public class Cylinder3DExample
extends ApplicationAdapter {
    PerspectiveCamera cam;
    ModelBatch modelBatch;
    SpriteBatch batch;
    Environment environment;
    Model model;
    ModelInstance instance;
    float rotationY = 0.0f;
    private BitmapFont font;

    @Override
    public void create() {
        this.cam = new PerspectiveCamera(67.0f, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        this.cam.position.set(0.0f, 0.0f, 5.0f);
        this.cam.lookAt(0.0f, 0.0f, 0.0f);
        this.cam.near = 1.0f;
        this.cam.far = 300.0f;
        this.cam.update();
        this.modelBatch = new ModelBatch();
        this.environment = new Environment();
        this.environment.set((Attribute)new ColorAttribute(ColorAttribute.AmbientLight, 0.8f, 0.8f, 0.8f, 1.0f));
        this.environment.add(new DirectionalLight().set(0.8f, 0.8f, 0.8f, -1.0f, -0.8f, -0.2f));
        ModelBuilder modelBuilder = new ModelBuilder();
        Texture texture = new Texture(Gdx.files.internal("c64.png"));
        Material material = new Material(TextureAttribute.createDiffuse(texture));
        float radius = 4.0f;
        float radiusTop = 4.0f;
        float height = 2.0f;
        int segments = 32;
        this.model = modelBuilder.createCylinder(radius, height, radiusTop, segments, material, 25L);
        this.instance = new ModelInstance(this.model);
        this.batch = new SpriteBatch();
        this.createFont();
    }

    private void createFont() {
        FreeTypeFontGenerator generator = new FreeTypeFontGenerator(Gdx.files.internal("Pixels.ttf"));
        FreeTypeFontGenerator.FreeTypeFontParameter parameter = new FreeTypeFontGenerator.FreeTypeFontParameter();
        parameter.size = 61;
        parameter.color = C64Colors.LIGHT_BLUE.toBadlogicColor();
        this.font = generator.generateFont(parameter);
        generator.dispose();
    }

    @Override
    public void render() {
        this.handleInput();
        Gdx.gl.glClear(16640);
        this.cam.update();
        this.instance.transform.setToRotation(Vector3.Y, this.rotationY);
        this.modelBatch.begin(this.cam);
        this.modelBatch.render((RenderableProvider)this.instance, this.environment);
        this.modelBatch.end();
        this.batch.begin();
        this.font.draw((Batch)this.batch, "Use cursor keys <- and -> to rotate the cylinder.", 2.0f, 72.0f);
        this.batch.end();
    }

    public void rotateLeft() {
        this.rotationY -= 3.0f;
    }

    public void rotateRight() {
        this.rotationY += 3.0f;
    }

    private void handleInput() {
        if (Gdx.input.isKeyJustPressed(21)) {
            this.rotateLeft();
        }
        if (Gdx.input.isKeyJustPressed(22)) {
            this.rotateRight();
        }
    }

    @Override
    public void dispose() {
        this.modelBatch.dispose();
        this.model.dispose();
    }
}

