/*
 * Decompiled with CFR 0.152.
 */
package org.kd.threed.adapters;

import com.badlogic.gdx.ApplicationAdapter;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Environment;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.ModelBatch;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.TextureAttribute;
import com.badlogic.gdx.graphics.g3d.environment.DirectionalLight;
import com.badlogic.gdx.graphics.g3d.utils.CameraInputController;
import com.badlogic.gdx.graphics.g3d.utils.ModelBuilder;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ScreenUtils;
import org.kd.common.tricks.Mesh;

public class MeshSurface
extends ApplicationAdapter {
    public final Color BACKGROUND_COLOUR = new Color(0.6f, 1.0f, 0.9254902f, 1.0f);
    private PerspectiveCamera cam;
    private CameraInputController camController;
    private Environment environment;
    private Array<ModelInstance> instances;
    private ModelBatch modelBatch;

    @Override
    public void create() {
        this.setUpCamera();
        this.camController = new CameraInputController(this.cam);
        Gdx.input.setInputProcessor(this.camController);
        this.modelBatch = new ModelBatch();
        this.setupEnv();
        Pixmap meshPixmap = Mesh.createMeshPixmap(Color.CYAN, 40, 5, 5);
        Texture textureGround = new Texture(meshPixmap);
        textureGround.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        textureGround.setWrap(Texture.TextureWrap.Repeat, Texture.TextureWrap.Repeat);
        TextureRegion textureGroundRegion = new TextureRegion(textureGround);
        int repeats = 3;
        textureGroundRegion.setRegion(0, 0, textureGround.getWidth() * repeats, textureGround.getHeight() * repeats);
        ModelBuilder modelBuilder = new ModelBuilder();
        Model modelGround = modelBuilder.createBox(100.0f, 1.0f, 100.0f, new Material(TextureAttribute.createDiffuse(textureGroundRegion)), 25L);
        this.instances = new Array();
        this.instances.add(new ModelInstance(modelGround, 0.0f, -1.0f, 0.0f));
    }

    private void setupEnv() {
        this.environment = new Environment();
        this.environment.set((Attribute)new ColorAttribute(ColorAttribute.AmbientLight, 0.6f, 0.6f, 0.6f, 1.0f));
        this.environment.add(new DirectionalLight().set(0.8f, 0.8f, 0.8f, -1.0f, -0.8f, -0.2f));
    }

    private void setUpCamera() {
        this.cam = new PerspectiveCamera(67.0f, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        this.cam.position.set(10.0f, 70.0f, 150.0f);
        this.cam.lookAt(0.0f, 0.0f, 0.5f);
        this.cam.near = 1.0f;
        this.cam.far = 1300.0f;
        this.cam.update();
    }

    @Override
    public void render() {
        this.camController.update();
        ScreenUtils.clear(this.BACKGROUND_COLOUR, true);
        this.modelBatch.begin(this.cam);
        this.modelBatch.render(this.instances, this.environment);
        this.modelBatch.end();
    }

    @Override
    public void dispose() {
        this.modelBatch.dispose();
    }
}

