/*
 * Decompiled with CFR 0.152.
 */
package org.kd.win311;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Cursor;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Vector2;
import org.kd.common.Helper;
import org.kd.common.Scene;

public final class Scene3ProgramMgr
extends Scene {
    public static final int START_FRAME = 300;
    public static final int PLAY_MUSIC_FRAME = 860;
    public static final String ID = "prgmgr";
    private Texture programMgrW;
    private Texture accesoriesW;
    private Texture mediaPlayerW;
    private Texture paintbrushW;
    private Texture musicFileW;
    private Batch batch;

    public Scene3ProgramMgr() {
        super(ID);
    }

    @Override
    public void create() {
        this.programMgrW = new Texture("win311/prgMgrWindow.png");
        this.accesoriesW = new Texture("win311/accessoriesWindow.png");
        this.mediaPlayerW = new Texture("win311/MediaPlayer.png");
        this.paintbrushW = new Texture("win311/paintbrush.png");
        this.musicFileW = new Texture("win311/musicFile.png");
        this.batch = new SpriteBatch();
    }

    @Override
    public void update(float delta) {
        if (this.getRelFrame() == 1L) {
            Gdx.input.setCursorPosition(Gdx.graphics.getWidth() / 2, Gdx.graphics.getHeight() / 2);
            Gdx.graphics.setSystemCursor(Cursor.SystemCursor.Ibeam);
        }
        if (this.getRelFrame() == 10L) {
            Gdx.graphics.setSystemCursor(Cursor.SystemCursor.Hand);
        }
        if (this.getRelFrame() > 50L && this.getRelFrame() < 198L) {
            int x1 = Gdx.graphics.getWidth() / 2;
            int y1 = Gdx.graphics.getHeight() / 2;
            int y2 = Gdx.graphics.getHeight() - 80;
            Helper.moveCursor(new Vector2(x1, y1), new Vector2(10.0f, y2), 50L, this.getRelFrame());
        } else if (this.getRelFrame() > 270L && this.getRelFrame() < 330L) {
            Helper.moveCursor(new Vector2(135.0f, 601.0f), new Vector2(205.0f, 615.0f), 270L, this.getRelFrame());
        } else if (this.getRelFrame() > 330L && this.getRelFrame() < 527L) {
            Helper.moveCursor(new Vector2(205.0f, 615.0f), new Vector2(29.0f, 103.0f), 333L, this.getRelFrame());
        } else if (this.getRelFrame() > 600L && this.getRelFrame() < 730L) {
            Helper.moveCursor(new Vector2(29.0f, 103.0f), new Vector2(179.0f, 90.0f), 530L, this.getRelFrame());
        } else if (this.getRelFrame() > 770L && this.getRelFrame() < 910L) {
            Helper.moveCursor(new Vector2(179.0f, 74.0f), new Vector2(205.0f, 500.0f), 770L, this.getRelFrame());
        }
    }

    @Override
    public void render() {
        Gdx.gl.glClearColor(0.7f, 0.7f, 0.7f, 1.0f);
        Gdx.gl.glClear(16384);
        this.batch.begin();
        if (this.getRelFrame() < 1000L) {
            if (this.getRelFrame() > 50L) {
                this.batch.draw(this.programMgrW, 60.0f, 90.0f);
            }
            if (this.getRelFrame() > 220L) {
                this.batch.draw(this.accesoriesW, 82.0f, 70.0f);
            }
        }
        if (this.getRelFrame() > 330L) {
            this.batch.draw(this.mediaPlayerW, 5.0f, 570.0f);
        }
        if (this.getRelFrame() > 527L && this.getRelFrame() < 730L) {
            this.batch.draw(this.musicFileW, 5.0f, 490.0f);
        }
        if (this.getRelFrame() > 1000L) {
            this.batch.draw(this.paintbrushW, 10.0f, 10.0f);
        }
        this.batch.end();
    }

    @Override
    public void dispose() {
    }

    private long getRelFrame() {
        long frame = Gdx.graphics.getFrameId();
        return frame - 300L;
    }
}

