/*
 * Decompiled with CFR 0.152.
 */
package org.kd.xmas25;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import java.util.List;
import org.kd.common.BasicC64Screen;
import org.kd.common.C64Colors;
import org.kd.common.ConsoleLogger;
import org.kd.common.Globals;
import org.kd.common.tricks.TravellingLogo;
import org.kd.common.winter.WinterEffects;
import org.kd.xmas25.BannerMCh;
import org.kd.xmas25.Mikolaj;
import org.kd.xmas25.PetsciiSnowman;

public class Scene2
extends BasicC64Screen {
    private final float xmasTreeScale = 0.8f;
    public SpriteBatch batch2;
    public ShapeRenderer shapeRenderer;
    private Mikolaj mikolaj1;
    private PetsciiSnowman snowman;
    private TravellingLogo scroll1;
    private TravellingLogo xmasTree;
    private Sprite forest;
    private Sprite mountain;
    private Sprite smallLogo;
    private Sprite socks;
    private Sprite bigPresent;
    private Sprite smallPresent;
    private List<Sprite> snowflakes;
    private boolean snowing;

    public Scene2(String id) {
        super(id);
        this.backgroundScreenPng = "lblue-ready.png";
        this.backgroundTexture = new Texture(Gdx.files.internal(this.backgroundScreenPng));
    }

    @Override
    public void create() {
        super.create();
        this.batch2 = new SpriteBatch();
        this.shapeRenderer = new ShapeRenderer();
        Texture mikolajPng = new Texture("dream210/mikolaj.png");
        this.mikolaj1 = new Mikolaj(mikolajPng);
        this.mikolaj1.setColor(Color.BLACK);
        this.snowman = new PetsciiSnowman();
        this.smallLogo = new Sprite(new Texture("dream210/c=xmas.png"));
        this.smallLogo.setPosition(100.0f, 344.0f);
        this.borderColor = C64Colors.WHITE;
        this.forest = new Sprite(new Texture("dream210/las2.png"));
        this.forest.setScale(0.1f);
        this.forest.setPosition(150.0f, 150.0f);
        this.mountain = new Sprite(new Texture("dream210/mountains.png"));
        this.mountain.setPosition(235.0f, 156.0f);
        this.mountain.setScale(1.95f);
        this.socks = new Sprite(new Texture("dream210/socks.png"));
        this.socks.setPosition(235.0f, 153.0f);
        this.socks.setScale(2.05f, 1.5f);
        this.bigPresent = new Sprite(new Texture("dream210/present1.png"));
        this.bigPresent.setPosition(90.0f, 133.0f);
        this.smallPresent = new Sprite(new Texture("dream210/present2.png"));
        this.smallPresent.setPosition(430.0f, 150.0f);
        this.snowflakes = WinterEffects.createSnowflakeSprites();
        this.snowflakes.forEach(flake -> flake.setX((float)((double)flake.getX() + 21.0 * Math.random())));
        for (int i = 0; i < this.snowflakes.size(); ++i) {
            float y = 101 * (i % 7);
            this.snowflakes.get(i).setY(y);
        }
        Texture scroll1 = new Texture("dream210/scroll/stanza1.bmp");
        this.scroll1 = new TravellingLogo(scroll1, 800.0f, 100.0f, 2000.0f, 16.0f);
        this.scroll1.spriteSpeed = 100.0f;
        Texture choinka = new Texture("dream210/tree/tree.png");
        this.xmasTree = new TravellingLogo(choinka, 800.0f, 100.0f, 417.0f, 438.0f);
        this.xmasTree.getSprite().setX(-100.0f);
        this.xmasTree.getSprite().setScale(0.8f);
    }

    @Override
    public void update(float delta) {
        super.update(delta);
        long frame = Gdx.graphics.getFrameId();
        if (frame == 2801L) {
            Globals.cursorY = Math.round(451.8) - 2L;
            Globals.BKG_COLOR = C64Colors.LIGHT_BLUE;
        }
        this.scroll1.move(delta, 800);
        if (frame > 2850L) {
            if (frame > 4475L) {
                this.mikolaj1.move();
            }
            this.handleScrollTextChange(frame);
            ConsoleLogger.logBannerWithElapsedTime(BannerMCh.lines);
        }
        if (frame > 3200L && this.snowman.getScaleY() < 0.55f) {
            this.snowman.setScale(this.snowman.getScaleX(), this.snowman.getScaleY() + 0.001f);
        }
        if (frame > 3600L) {
            double alpha = Math.PI * (double)(3600L - frame) / 50.0;
            float y = (float)(0.5 + 0.02 * Math.sin(alpha));
            this.snowman.setScale(0.55f, y);
        }
        float treeX = this.xmasTree.getSprite().getX();
        if (7700L < frame) {
            Texture treeBlink1 = new Texture("dream210/tree/tree4.png");
            Texture treeBlink2 = new Texture("dream210/tree/tree3.png");
            Texture treeBlink3 = new Texture("dream210/tree/tree2.png");
            float x = this.xmasTree.getX();
            float y = this.xmasTree.getSprite().getY();
            if (treeX < 300.0f) {
                this.xmasTree.getSprite().setX(treeX + 2.0f);
            } else if (frame % 45L == 30L) {
                this.xmasTree.changeTexture(treeBlink1);
                this.xmasTree.getSprite().setPosition(x, y);
                this.xmasTree.getSprite().setScale(0.8f);
            }
            if (frame % 45L == 15L) {
                this.xmasTree.changeTexture(treeBlink2);
                this.xmasTree.getSprite().setPosition(x, y);
                this.xmasTree.getSprite().setScale(0.8f);
            } else if (frame % 45L == 0L) {
                this.xmasTree.changeTexture(treeBlink3);
                this.xmasTree.getSprite().setPosition(x, y);
                this.xmasTree.getSprite().setScale(0.8f);
            }
        }
        if (this.snowing) {
            for (int startIndex = 0; startIndex <= 6; ++startIndex) {
                if (frame <= (long)(2340 + startIndex * 100)) continue;
                WinterEffects.snow(startIndex, this.snowflakes);
            }
        }
    }

    private void handleScrollTextChange(long frame) {
        if (frame == 4475L) {
            this.scroll1.changeTexture(new Texture("dream210/scroll/stanza2.bmp"));
            this.snowing = true;
        } else if (frame == 6200L) {
            this.scroll1.changeTexture(new Texture("dream210/scroll/stanza3.bmp"));
        } else if (frame == 7700L) {
            this.scroll1.changeTexture(new Texture("dream210/scroll/stanza4.bmp"));
            this.scroll1.getSprite().setScale(1.45f, 1.0f);
            this.scroll1.spriteSpeed = 105.0f;
        } else if (frame == 9280L) {
            this.scroll1.spriteSpeed = 0.0f;
        }
    }

    @Override
    public void render() {
        super.render();
        long relativeFrame = Gdx.graphics.getFrameId() - 2800L;
        this.batch2.begin();
        if (relativeFrame < 1555L) {
            if (relativeFrame > 100L) {
                this.smallLogo.draw(this.batch2);
            }
            if (relativeFrame > 400L) {
                this.snowman.draw(this.batch2);
            }
        }
        if (this.snowing) {
            if (450L < relativeFrame && relativeFrame <= 3400L) {
                if (relativeFrame > 3000L) {
                    this.batch2.draw(new Texture("dream210/tramiel.png"), 300.0f, 230.0f);
                }
                this.mountain.draw(this.batch2);
            } else if (3400L < relativeFrame && relativeFrame <= 4900L) {
                this.socks.draw(this.batch2);
                this.backgroundScreenPng = "lgrey-ready.png";
                this.backgroundTexture = new Texture(Gdx.files.internal(this.backgroundScreenPng));
                Globals.BKG_COLOR = C64Colors.GRAY;
            } else {
                if (relativeFrame > 4900L) {
                    this.mikolaj1.setColor(C64Colors.WHITE.toBadlogicColor());
                    this.backgroundScreenPng = "lblack-ready.png";
                    this.borderColor = C64Colors.BLACK;
                    Globals.BKG_COLOR = C64Colors.BLACK;
                    this.mikolaj1.setColor(Color.CYAN);
                } else {
                    this.backgroundScreenPng = "lblue-ready.png";
                }
                this.backgroundTexture = new Texture(Gdx.files.internal(this.backgroundScreenPng));
            }
            if (relativeFrame > 6550L) {
                String msg = relativeFrame < 6870L ? "CODE  & GFX: KD" : "MSX: KD & https://csdb.dk/sid/?id=26004";
                this.whiteFont.draw((Batch)this.batch2, msg, 81.0f, 500.0f);
                float y = this.mikolaj1.getY() + 1.0f;
                this.mikolaj1.setY(y);
            }
            if (4900L < relativeFrame && relativeFrame < 6550L) {
                this.handlePresents(relativeFrame);
            }
            this.snow(relativeFrame);
        }
        if (relativeFrame > 1675L) {
            this.mikolaj1.draw(this.batch2);
        }
        this.scroll1.draw(this.batch2, 800, 600);
        this.batch2.end();
        C64Colors hidersColor = relativeFrame > 4900L ? C64Colors.BLACK : C64Colors.WHITE;
        this.shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
        this.shapeRenderer.setColor(hidersColor.toBadlogicColor());
        this.shapeRenderer.rect(0.0f, 100.0f, 80.0f, 400.0f);
        this.shapeRenderer.rect(720.0f, 100.0f, 80.0f, 400.0f);
        if (relativeFrame > 5140L) {
            this.shapeRenderer.rect(79.0f, 510.0f, 400.0f, 12.0f);
        }
        this.shapeRenderer.end();
    }

    private void handlePresents(long relativeFrame) {
        this.xmasTree.draw(this.batch2, 800, 600);
        if (relativeFrame > 5300L) {
            this.bigPresent.draw(this.batch2);
            if (relativeFrame > 5500L) {
                this.smallPresent.draw(this.batch2);
            }
        }
    }

    private void snow(long relativeFrame) {
        for (int startIndex = 0; startIndex <= 6; ++startIndex) {
            if (relativeFrame + 2800L <= (long)(400 + startIndex * 100)) continue;
            for (int i = startIndex; i < this.snowflakes.size(); i += 7) {
                this.snowflakes.get(i).draw(this.batch2);
            }
        }
    }
}

