program lights;

uses
	xdoor,
  xplayer,
  xstrings,
  xfileio,
  xmisc,
  xlbar,
  xsprites,
  xtdf,
  xmap;
  
Var
  pl      : aplayer;
  tiles   : tsprites;
  randomgame  : boolean;
  
  
Procedure ShowScore;
var i:byte;
Begin
  SetAttr(7);
  cClrScr;
  showfile('.'+pathsep+'gfx'+pathsep+'score.ans',false);
  for i:=1 to maxplayers do begin
    writexy(24,7+i,15,Highscore[i].text);
    writexy(45,7+i,8,numpad(Highscore[i].moves,5));
    writexy(51,7+i,7,numpad(Highscore[i].score,5));
  end;
  inkey;
End;

Procedure ShowAbout;
Begin
  SetAttr(7);
  cClrScr;
  showfile('.'+pathsep+'gfx'+pathsep+'about.ans',false);
  inkey;
End;

Procedure DrawMap;
Var 
  x,y:byte;
  t:byte;
Begin
  for y:=0 to 4 do
    for x:=0 to 4 do begin
      t:=gettile(x,y);
      tiles.ShowSpriteName(33+(x*6),5+(y*3),itos(t));
    end;
End;

Function IsBoardClear:Boolean;
var
  x,y:byte;
Begin
  IsBoardClear:=True;
  for y:=0 to MapHeight - 1 do
    for x:=0 to MapWidth -1 do 
      if gettile(x,y) = 1 then begin
        IsBoardClear := False;
        exit;
      end;
End;

Procedure ToggleTile(nx,ny:byte);
  Begin
    if GetTile(nx, ny) = 0 then
      SetTile(nx,ny,1)
    else
      SetTile(nx,ny,0);
  End;

procedure ToggleTiles(x,y:byte);
var
  dx, dy: Integer;
begin
  toggletile(x,y);
  if x-1<>255 then toggletile(x-1,y);
  if x+1<MapWidth  then toggletile(x+1,y);
  if y-1<>255 then toggletile(x,y-1);
  if y+1<MapHeight then toggletile(x,y+1);
End;

Procedure ShowSprite(x,y,v:byte);
Begin
  tiles.ShowSpriteName(33+(x*6),5+(y*3),itos(v));
End;

Procedure Game;
var
  level:byte;
  key : char;
  goback:boolean;
  posx,posy:byte;
  prex,prey:byte;
  moves: integer;
  oldmoves: integer;
  
  Procedure RandomMap;
  var
    r,cx,cy:byte;
  Begin
    for r := 0 to 50 do begin
      cx := random(MapWidth);
      cy := random(MapHeight);
      ToggleTile(cx, cy);
    end;
  End;
  
  Procedure UpdateText;
  Begin
    writexy(12,9,7,padleft(userhandle,' ',10));
    writexy(12,13,7,padleft(itos(moves),' ',10));
    writexy(12,17,7,padleft(itos(level),' ',10));
  End;
  
  Procedure ResetMap;
  Begin
    posx:=0;
    posy:=0;
    prex:=0;
    prey:=0;
    oldmoves:=moves;
    
    if randomgame then begin
      randommap;    
    end else if not LoadMap('.'+pathsep+'levels'+pathsep+''+itos(level)+'.txt') then begin
      setattr(7);
      cclrscr;
      out('Error loading level map: '+itos(level));
      inkey;
      goback:=true;
    end;
    SetAttr(7);
    cClrScr;cClrScr;
    showfile('.'+pathsep+'gfx'+pathsep+'board.ans',false);
    drawmap;
    updatetext;
  End;
  
  procedure animategridend;
  var
    d,z:byte;
  begin
    for d:=0 to mapheight-1 do 
      for z:=0 to mapwidth -1 do settile(z,d,0);
    Drawmap;
    for d:=0 to mapheight-1 do 
      for z:=0 to mapwidth -1 do begin
        ShowSprite(z,d,1);
        delay(100);
        ShowSprite(z,d,0);
        delay(20);
      end;
  end;
  
  procedure animategridx;
  var
    d,z:byte;
  begin
    for d:=0 to mapheight-1 do 
      for z:=0 to mapwidth -1 do settile(z,d,0);
    Drawmap;
    ShowSprite(0,0,1);
    ShowSprite(4,0,1);
    ShowSprite(1,1,1);
    ShowSprite(3,1,1);
    ShowSprite(2,2,1);
    ShowSprite(1,3,1);
    ShowSprite(3,3,1);
    ShowSprite(0,4,1);
    ShowSprite(4,4,1);
    delay(1000);
  end;
    
Begin
  level:=1;
  moves:=0;
  oldmoves:=0;
  goback:=false;
  InitMap(5,5);  
  ResetMap;
  repeat
    tiles.ShowSpriteName(33+(prex*6),5+(prey*3),itos(gettile(prex,prey)));
    tiles.ShowSpriteName(33+(posx*6),5+(posy*3),'s'+itos(gettile(posx,posy)));
    {writexy(1,1,14,itos(posx)+'/'+itos(posy)+'/'+itos(gettile(posx,posy)));}
    key:=upcase(inkey);
    prex:=posx;
    prey:=posy;
    if key = #27 then  goback := true
    else if (key = #32) or (key=#13) then Begin
      ToggleTiles(posx,posy);
      drawmap;
    end
    else if key = 'N' then begin
      level:=level+1;
      resetmap;
    end
    else if key = 'R' then ResetMap
    else if hitup then begin
      moves:=moves+1;
      posy:=posy-1;
      if posy=255 then posy:=0;
    end
    else if hitdown then begin
      moves:=moves+1;
      posy:=posy+1;
      if posy>MapHeight-1 then posy:=MapHeight-1;
    end
    else if hitleft then begin
      moves:=moves+1;
      posx:=posx-1;
      if posx=255 then posx:=0;
    end
    else if hitright then begin
      moves:=moves+1;
      posx:=posx+1;
      if posx>MapWidth-1 then posx:=MapWidth-1;
    end;
    
    if isBoardClear then begin
      if moves-oldmoves>50 then animategridx;
      pl.moves:=moves;
      pl.score:=level;
      level:=level+1;
      if not fileexists('.'+pathsep+'levels'+pathsep+''+itos(level)+'.txt') then begin
        animategridend;
        goback := true;
      end;
      resetmap;
    end;
    updatetext;
    
  until goback;
  
  pl.moves:=moves;
  pl.score:=level;
  DeInitMap;
End;

Procedure Main;
Var
  mx,my: byte;
  sel:byte;
Begin
  randomgame:=false;  
  InitLightBars(5);
  mx:=35;my:=16;
  AddLightBar (mx,my,'|21|15> Classic <','|16|15  Classic  ');
  AddLightBar (mx,my+1,'|21|15>  Random <','|16|15   Random  ');
  AddLightBar (mx,my+2,'|21|15>  About  <','|16|15   About   ');
  AddLightBar (mx,my+3,'|21|15> HiScore <','|16|15  HiScore  ');
  AddLightBar (mx,my+4,'|21|15>   Exit  <','|16|15    Exit   ');
  Repeat
    SetAttr(7);
    cClrScr;
    showfile('.'+pathsep+'gfx'+pathsep+'lights.ans',false);
    xtdf.init('.'+pathsep+'gfx'+pathsep+'codex.tdf');
    selectfont(1);
    xtdf.WriteStr(10,8,'LIGHTS OUT');
    writexy(65,12,8,'Ver.1.0');
    sel := LightBar(1);
    
    case sel of
      1: begin
          initplayer(pl);
          pl.text := userhandle;
          game;
          exitplayer(pl);
        end;
      2: begin
          initplayer(pl);
          pl.text := userhandle;
          randomgame:=true;
          game;
          randomgame:=false;
        end;
      3: showabout;
      4: showscore;
      5: sel:=5;
    end;
  until sel = 5;
  DeInitLightBars;
  setattr(7);
  cclrscr;
End;
  
Begin
  HighScoreFile := 'hiscore.dat';
  CreateHighScoreTable;
  doorName := ' Lights Out ';
  initdoor;
  tiles.init;
  tiles.loadfile('.'+pathsep+'gfx'+pathsep+'tiles.ans');
  main;
  tiles.done;
End.
