
// --- Perlin Noise.

int rand1=0x1984AD54, rand2=0xDEADBEEF, rand3=0x303F909F;

#pragma warning( push )
#pragma warning( disable : 4035 )

int Rand( void )
  {
    __asm {
      mov eax, [rand1]
      mov ecx, [rand2]
      add eax,ecx
      rol eax,cl
      add ecx, 0x12345678
      ror ecx,3
      mov [rand1], eax
      mov [rand2], ebx
      add eax, [rand3]
      sub [rand3], 0x298743
      }
   }

#pragma warning( pop )

float NoiseBuf[64][64];

void Noise_Init( void )
  {
    for ( int i = 0; i < 64; i++ )
      for ( int j = 0; j < 64; j++ )
        NoiseBuf[ i ][ j ] = (float) ( Rand() & 1023 ) / 1023.0f;
   }

float Noise_CosInterp( float I1, float I2, float x )
  { return ( I1 + ( I2 - I1 ) * ( 1.0f - Fcos( x * Pi )) * 0.5f );
   }

float Noise_2D( float x, float y )
  {
    int ix = Trunc( x );
    int iy = Trunc( y );
    float N1 = Noise_CosInterp( NoiseBuf[ ix & 63 ][ iy & 63 ], NoiseBuf[ (ix+1) & 63 ][ iy & 63 ], Frac( x ));
    float N2 = Noise_CosInterp( NoiseBuf[ ix & 63 ][ (iy+1) & 63 ], NoiseBuf[ (ix+1) & 63 ][ (iy+1) & 63 ], Frac( x ));
    return Noise_CosInterp( N1, N2, Frac( y ));
   }

float Noise( float x, float y, int depth )
  {
    float Val = 0.0f, Amp = 1.0f;
    if ( depth > 8 ) depth = 8;
    for ( int i = 0; i < depth; i++ )
      { 
        Val += ( Noise_2D( x*64*Amp, y*64*Amp ) / ( 2*Amp ));
        Amp *= 2.0f;
       }
    return Val;
   }

// ---------- Effect1: HexaTunnel.

Object HexaTun;

void HexaTun_Init( void )
  {
     glClearColor( BackR, BackG, BackB, 0.0f );
     glClearDepth( 100.0f );

     glDepthFunc( GL_LEQUAL );
     glEnable( GL_DEPTH_TEST );

     glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );

     glShadeModel( GL_SMOOTH );
/*
     glBlendFunc( GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA );
     glEnable( GL_BLEND );
     glLineWidth( 3.0f );
     glEnable( GL_LINE_SMOOTH );
     glPolygonMode( GL_FRONT_AND_BACK, GL_LINE );
*/
     HexaTun.NumVects = 8192;
     if (( HexaTun.Vects = (Vect*) malloc( HexaTun.NumVects * sizeof( Vect ))) == NULL ) 
       PostQuitMessage( 0 );
     
     HexaTun.NumFaces = 8192;
     if (( HexaTun.Faces = (Face*) malloc( HexaTun.NumFaces * sizeof( Face ))) == NULL )
       PostQuitMessage( 0 );
   }

float x0, y0, z0, Col, Rad = 2.0f;
int V=0, F=0;

void HexaTun_Gen( float Timer, float Pulse )
  {
    float DX, DY, DZ, CDist;
    
    Vertex( &HexaTun.Vects[ V+0 ], x0, y0, z0+Rad*0.5f*Pulse );
    Vertex( &HexaTun.Vects[ V+1 ], x0 + y0*0.217f*Pulse, y0 - x0*0.217f*Pulse, z0+Rad*0.25f*Pulse );
    Vertex( &HexaTun.Vects[ V+2 ], x0 + y0*0.217f*Pulse, y0 - x0*0.217f*Pulse, z0-Rad*0.25f*Pulse );
    Vertex( &HexaTun.Vects[ V+3 ], x0, y0, z0-Rad*0.5f*Pulse );
    Vertex( &HexaTun.Vects[ V+4 ], x0 - y0*0.217f*Pulse, y0 + x0*0.217f*Pulse, z0-Rad*0.25f*Pulse );
    Vertex( &HexaTun.Vects[ V+5 ], x0 - y0*0.217f*Pulse, y0 + x0*0.217f*Pulse, z0+Rad*0.25f*Pulse );

    Vertex( &HexaTun.Vects[ V+6 ], 1.06f*x0, 1.06f*y0, z0+Rad*0.5f*Pulse );
    Vertex( &HexaTun.Vects[ V+7 ], 1.06f*x0 + y0*0.217f*Pulse, 1.06f*y0 - x0*0.217f*Pulse, z0+Rad*0.25f*Pulse );
    Vertex( &HexaTun.Vects[ V+8 ], 1.06f*x0 + y0*0.217f*Pulse, 1.06f*y0 - x0*0.217f*Pulse, z0-Rad*0.25f*Pulse );
    Vertex( &HexaTun.Vects[ V+9 ], 1.06f*x0, 1.06f*y0, z0-Rad*0.5f*Pulse );
    Vertex( &HexaTun.Vects[ V+10 ], 1.06f*x0 - y0*0.217f*Pulse, 1.06f*y0 + x0*0.217f*Pulse, z0-Rad*0.25f*Pulse );
    Vertex( &HexaTun.Vects[ V+11 ], 1.06f*x0 - y0*0.217f*Pulse, 1.06f*y0 + x0*0.217f*Pulse, z0+Rad*0.25f*Pulse );

    HexaTun.Faces[ F ].Type = 4;
    HexaTun.Faces[ F ].A = V;
    HexaTun.Faces[ F ].B = V+1;
    HexaTun.Faces[ F ].C = V+2;
    HexaTun.Faces[ F ].D = V+3;
    HexaTun.Faces[ F ].pA = &HexaTun.Vects[ V ];
    HexaTun.Faces[ F ].pB = &HexaTun.Vects[ V+1 ];
    HexaTun.Faces[ F ].pC = &HexaTun.Vects[ V+2 ];
    HexaTun.Faces[ F ].pD = &HexaTun.Vects[ V+3 ];
    HexaTun.Faces[ F ].ColR = 0.110f; // 0.549f;
    HexaTun.Faces[ F ].ColG = 0.298f; // 0.663f;
    HexaTun.Faces[ F ].ColB = 0.376f; // 0.584f;
      DX = HexaTun.Faces[ F ].pA->X - Camp.X;
      DY = HexaTun.Faces[ F ].pA->Y - Camp.Y;
      DZ = HexaTun.Faces[ F ].pA->Z - Camp.Z;
      CDist = Fsqrt( DX*DX + DY*DY + DZ*DZ ) * 0.04f;
      if ( CDist > 1.0f ) CDist = 1.0f;
      Col *= 1.0f - CDist;
      if ( Col > 0.8f ) Col = 0.8f;
    HexaTun.Faces[ F++ ].Shade = Col;

    HexaTun.Faces[ F ].Type = 4;
    HexaTun.Faces[ F ].A = V+3;
    HexaTun.Faces[ F ].B = V+4;
    HexaTun.Faces[ F ].C = V+5;
    HexaTun.Faces[ F ].D = V;
    HexaTun.Faces[ F ].pA = &HexaTun.Vects[ V+3 ];
    HexaTun.Faces[ F ].pB = &HexaTun.Vects[ V+4 ];
    HexaTun.Faces[ F ].pC = &HexaTun.Vects[ V+5 ];
    HexaTun.Faces[ F ].pD = &HexaTun.Vects[ V ];
    HexaTun.Faces[ F ].ColR = 0.110f; // 0.549f;
    HexaTun.Faces[ F ].ColG = 0.298f; // 0.663f;
    HexaTun.Faces[ F ].ColB = 0.376f; // 0.584f;
    HexaTun.Faces[ F++ ].Shade = Col;

    HexaTun.Faces[ F ].Type = 4;
    HexaTun.Faces[ F ].A = V;
    HexaTun.Faces[ F ].B = V+1;
    HexaTun.Faces[ F ].C = V+7;
    HexaTun.Faces[ F ].D = V+6;
    HexaTun.Faces[ F ].pA = &HexaTun.Vects[ V ];
    HexaTun.Faces[ F ].pB = &HexaTun.Vects[ V+1 ];
    HexaTun.Faces[ F ].pC = &HexaTun.Vects[ V+7 ];
    HexaTun.Faces[ F ].pD = &HexaTun.Vects[ V+6 ];
    HexaTun.Faces[ F ].ColR = 0.173f; // 0.404f;
    HexaTun.Faces[ F ].ColG = 0.408f; // 0.502f;
    HexaTun.Faces[ F ].ColB = 0.471f; // 0.522f;
    HexaTun.Faces[ F++ ].Shade = Col;

    HexaTun.Faces[ F ].Type = 4;
    HexaTun.Faces[ F ].A = V+3;
    HexaTun.Faces[ F ].B = V+4;
    HexaTun.Faces[ F ].C = V+10;
    HexaTun.Faces[ F ].D = V+9;
    HexaTun.Faces[ F ].pA = &HexaTun.Vects[ V+3 ];
    HexaTun.Faces[ F ].pB = &HexaTun.Vects[ V+4 ];
    HexaTun.Faces[ F ].pC = &HexaTun.Vects[ V+10 ];
    HexaTun.Faces[ F ].pD = &HexaTun.Vects[ V+9 ];
    HexaTun.Faces[ F ].ColR = 0.173f; // 0.404f;
    HexaTun.Faces[ F ].ColG = 0.408f; // 0.502f;
    HexaTun.Faces[ F ].ColB = 0.471f; // 0.522f;
    HexaTun.Faces[ F++ ].Shade = Col;

    HexaTun.Faces[ F ].Type = 4;
    HexaTun.Faces[ F ].A = V+1;
    HexaTun.Faces[ F ].B = V+2;
    HexaTun.Faces[ F ].C = V+8;
    HexaTun.Faces[ F ].D = V+7;
    HexaTun.Faces[ F ].pA = &HexaTun.Vects[ V+1 ];
    HexaTun.Faces[ F ].pB = &HexaTun.Vects[ V+2 ];
    HexaTun.Faces[ F ].pC = &HexaTun.Vects[ V+8 ];
    HexaTun.Faces[ F ].pD = &HexaTun.Vects[ V+7 ];
    HexaTun.Faces[ F ].ColR = 0.188f; // 0.345f;
    HexaTun.Faces[ F ].ColG = 0.439f; // 0.423f;
    HexaTun.Faces[ F ].ColB = 0.518f; // 0.447f;
    HexaTun.Faces[ F++ ].Shade = Col;

    HexaTun.Faces[ F ].Type = 4;
    HexaTun.Faces[ F ].A = V+4;
    HexaTun.Faces[ F ].B = V+5;
    HexaTun.Faces[ F ].C = V+11;
    HexaTun.Faces[ F ].D = V+10;
    HexaTun.Faces[ F ].pA = &HexaTun.Vects[ V+4 ];
    HexaTun.Faces[ F ].pB = &HexaTun.Vects[ V+5 ];
    HexaTun.Faces[ F ].pC = &HexaTun.Vects[ V+11 ];
    HexaTun.Faces[ F ].pD = &HexaTun.Vects[ V+10 ];
    HexaTun.Faces[ F ].ColR = 0.188f; // 0.345f;
    HexaTun.Faces[ F ].ColG = 0.439f; // 0.423f;
    HexaTun.Faces[ F ].ColB = 0.518f; // 0.447f;
    HexaTun.Faces[ F++ ].Shade = Col;

    HexaTun.Faces[ F ].Type = 4;
    HexaTun.Faces[ F ].A = V+2;
    HexaTun.Faces[ F ].B = V+3;
    HexaTun.Faces[ F ].C = V+9;
    HexaTun.Faces[ F ].D = V+8;
    HexaTun.Faces[ F ].pA = &HexaTun.Vects[ V+2 ];
    HexaTun.Faces[ F ].pB = &HexaTun.Vects[ V+3 ];
    HexaTun.Faces[ F ].pC = &HexaTun.Vects[ V+9 ];
    HexaTun.Faces[ F ].pD = &HexaTun.Vects[ V+8 ];
    HexaTun.Faces[ F ].ColR = 0.235f; // 0.286f;
    HexaTun.Faces[ F ].ColG = 0.486f; // 0.345f;
    HexaTun.Faces[ F ].ColB = 0.565f; // 0.372f;
    HexaTun.Faces[ F++ ].Shade = Col;

    HexaTun.Faces[ F ].Type = 4;
    HexaTun.Faces[ F ].A = V+5;
    HexaTun.Faces[ F ].B = V;
    HexaTun.Faces[ F ].C = V+6;
    HexaTun.Faces[ F ].D = V+11;
    HexaTun.Faces[ F ].pA = &HexaTun.Vects[ V+5 ];
    HexaTun.Faces[ F ].pB = &HexaTun.Vects[ V ];
    HexaTun.Faces[ F ].pC = &HexaTun.Vects[ V+6 ];
    HexaTun.Faces[ F ].pD = &HexaTun.Vects[ V+11 ];
    HexaTun.Faces[ F ].ColR = 0.235f; // 0.286f;
    HexaTun.Faces[ F ].ColG = 0.486f; // 0.345f;
    HexaTun.Faces[ F ].ColB = 0.565f; // 0.372f;
    HexaTun.Faces[ F++ ].Shade = Col;
    
    V += 12;
   }

void HexaTun_Draw( float Timer, float Pulse )
  { 
    int i, j;
    // float Pulse2;

    Camp.X = 3.0f*Fcos( Timer*0.000348f ); // 0.00029f
    Camp.Y = 3.0f*Fsin( Timer*0.00132f ); // 0.0011f
    Camp.Z = Fcos( Timer*0.001128f ); // 0.00094f

    // --- Generate Object.

    F = 0;
    V = 0;

    for ( i = -12; i < 1  /* 12 */; i++ )
      {
        for ( j = 0; j < 12; j++ )
          { 
            Col = ( 10.0f - Fabs( i + 2.0f * Frac( Timer * 0.006f ))) / 20.0f;
            if ( i & 1 )
              { 
                x0 = 4.0f * Fsin( j * Pi / 6 );
                y0 = 4.0f * Fcos( j * Pi / 6 );
               } else
              { 
                x0 = 4.0f * Fsin( j * Pi / 6 + Pi / 12 );
                y0 = 4.0f * Fcos( j * Pi / 6 + Pi / 12 );
               }          
            z0 = ( i + 2.0f * Frac( Timer * 0.006f )) * 1.86f;
//         Pulse2 = ( 1.0f - Noi ) * Pulse + Noi * ( 0.7f + 0.3f * Noise(( trunc( Timer * 0.006f ) + i ) / 12.0f, j / 12.0f, 5 ));
            HexaTun_Gen( Timer, Pulse );
           }
        if ( i ) 
          {
            for ( j = 0; j < 12; j++ )
              {
                Col = ( 10.0f - Fabs( -i + 2.0f * Frac( Timer * 0.006f ))) / 20.0f;
                if ( i & 1 ) 
                  { 
                    x0 = 4.0f * Fsin( j * Pi / 6 );
                    y0 = 4.0f * Fcos( j * Pi / 6 );
                   } else
                  {
                    x0 = 4.0f * Fsin( j * Pi / 6 + Pi / 12 );
                    y0 = 4.0f * Fcos( j * Pi / 6 + Pi / 12 );
                   }
                z0 = ( -i + 2.0f * Frac( Timer * 0.006f )) * 1.86f;
//             Pulse2 = ( 1.0f - Noi ) * Pulse + Noi * ( 0.7f + 0.3f * Noise(( trunc( Timer * 0.006f ) - i ) / 12.0f, j / 12.0f, 5 ));
                HexaTun_Gen( Timer, Pulse );
               }
           }
       }

    HexaTun.NumVects = V;
    HexaTun.NumFaces = F;

    // --- Draw!

    glMatrixMode( GL_PROJECTION );
    glLoadIdentity();
    gluPerspective( 90.0f, 640.0f / 360.0f, 1.0f, 100.0f ); 

    gluLookAt( Camp.X, Camp.Y, Camp.Z, Fsin( Timer*0.0005f ), Fcos( Timer*0.00037f ), 2.0f*Fsin( Timer*0.00031f ), 0.0f, 1.0f, 0.0f );

    glMatrixMode( GL_MODELVIEW );
    glLoadIdentity();

    DrawObject( &HexaTun, 0.0f, 0.0f, 0.0f );
   }
